/*
 * Decompiled with CFR 0.152.
 */
package com.valor.gray.feignextension.ribbon;

import com.netflix.loadbalancer.ServerListFilter;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class GrayFilter
implements ServerListFilter<DiscoveryEnabledServer> {
    private static final Logger logger = LogManager.getLogger(GrayFilter.class);

    public List<DiscoveryEnabledServer> getFilteredListOfServers(List<DiscoveryEnabledServer> servers) {
        String targetVersion = this.getTargetVersion();
        if (StringUtils.isEmpty((CharSequence)targetVersion)) {
            logger.debug("[feign extension] gray server filter: return all servers, because targetVersion is empty");
            return servers;
        }
        ArrayList<DiscoveryEnabledServer> targetVersionServers = new ArrayList<DiscoveryEnabledServer>();
        for (DiscoveryEnabledServer server : servers) {
            String version = (String)server.getInstanceInfo().getMetadata().get("version");
            if (StringUtils.isEmpty((CharSequence)version)) {
                logger.debug("[feign extension] gray server filter: server({}) ignore, because server version is empty", (Object)server.getInstanceInfo().getAppName());
                continue;
            }
            if (!version.equals(targetVersion)) continue;
            targetVersionServers.add(server);
        }
        if (CollectionUtils.isEmpty(targetVersionServers)) {
            logger.debug("[feign extension] gray server filter: return normal server");
            return servers;
        }
        logger.debug("[feign extension] gray server filter: return gray server");
        return targetVersionServers;
    }

    private String getTargetVersion() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            logger.error("[feign extension] gray server filter failed: RequestContextHolder.getRequestAttributes() is null");
            return null;
        }
        HttpServletRequest oldRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        return oldRequest.getHeader("targetVersion");
    }
}

