/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mercury.sender.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.valor.mercury.sender.service.MetricMessage;
import com.valor.mercury.sender.util.Base64Util;
import com.valor.mercury.sender.util.DeflateUtil;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class MercurySender {
    private static boolean isInit = false;
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static Map<String, MercurySender> senders = new HashMap<String, MercurySender>();
    private static final int maxQueueSizeForClientUse = 5000;
    private static final int maxQueueSizeForServerUse = 200000;
    private static final int defaultQueueSize = 2000;
    private String appId;
    private String appKey;
    private String key;
    private boolean forClientUse;
    private int postBatchSize = 1000;
    private int postBatchInterval = 1000;
    private boolean debug;
    private int triesOnServer;
    private int triesTotal;
    private int maxTriesOnServer = 2;
    private int maxTriesTotal = 6;
    private int currentServer = -1;
    private Queue<Integer> candidateServers;
    private String[] serverUrls;
    private BlockingQueue<MetricMessage> bufferQueue;
    private List<MetricMessage> list;
    private long lastSendTimeMillis;

    public static void init(Map<String, String[]> urls, String appId, String appKey, int postBatchSize, int postBatchInterval, int triesOnServer, int triesTotal, int queueSize, boolean debug, boolean forClientUse) {
        if (isInit) {
            return;
        }
        for (String key : urls.keySet()) {
            senders.put(key, new MercurySender(key, urls.get(key), appId, appKey, postBatchSize, postBatchInterval, triesOnServer, triesTotal, queueSize, debug, forClientUse));
        }
        isInit = true;
    }

    public static void init(Map<String, String[]> urls, String appId, String appKey, boolean forClientUse) {
        if (isInit) {
            return;
        }
        for (String key : urls.keySet()) {
            senders.put(key, new MercurySender(key, urls.get(key), appId, appKey, -1, -1, -1, -1, -1, false, forClientUse));
        }
        isInit = true;
    }

    public static void init(Map<String, String[]> urls, String appId, String appKey, int queueSize, boolean forClientUse) {
        if (isInit) {
            return;
        }
        for (String key : urls.keySet()) {
            senders.put(key, new MercurySender(key, urls.get(key), appId, appKey, -1, -1, -1, -1, queueSize, false, forClientUse));
        }
        isInit = true;
    }

    public static void init(Map<String, String[]> urls, String appId, String appKey, int queueSize, boolean debug, boolean forClientUse) {
        if (isInit) {
            return;
        }
        for (String key : urls.keySet()) {
            senders.put(key, new MercurySender(key, urls.get(key), appId, appKey, -1, -1, -1, -1, queueSize, debug, forClientUse));
        }
        isInit = true;
    }

    private MercurySender(String key, String[] urls, String appId, String appKey, int postBatchSize, int postBatchInterval, int maxTriesOnServer, int maxTriesTotal, int queueSize, boolean debug, boolean forClientUse) {
        this.forClientUse = forClientUse;
        this.debug = debug;
        this.key = key;
        this.appId = appId;
        this.appKey = appKey;
        if (postBatchSize > 0) {
            this.postBatchSize = postBatchSize;
        }
        if (postBatchInterval > 0) {
            this.postBatchInterval = postBatchInterval;
        }
        this.bufferQueue = queueSize > 0 ? (forClientUse ? new LinkedBlockingQueue<MetricMessage>(Math.min(queueSize, 5000)) : new LinkedBlockingQueue<MetricMessage>(Math.min(queueSize, 200000))) : new LinkedBlockingQueue<MetricMessage>(2000);
        if (maxTriesOnServer > 0) {
            this.maxTriesOnServer = maxTriesOnServer;
        }
        if (maxTriesTotal > 0) {
            this.maxTriesTotal = maxTriesTotal;
        }
        this.list = new ArrayList<MetricMessage>();
        this.lastSendTimeMillis = System.currentTimeMillis();
        if (urls == null || urls.length <= 0) {
            throw new IllegalArgumentException("server size must be greater than 0");
        }
        this.serverUrls = urls;
        this.candidateServers = new ArrayBlockingQueue<Integer>(this.serverUrls.length);
        ArrayList<Integer> serverList = new ArrayList<Integer>(){
            {
                for (int i = 0; i < MercurySender.this.serverUrls.length; ++i) {
                    this.add(i);
                }
            }
        };
        Collections.shuffle(serverList);
        this.candidateServers.addAll((Collection<Integer>)serverList);
        this.nextServer();
        new Thread(this::run, this.key + "-wordThread").start();
    }

    public static void put(String key, String eventName, Map<String, Object> fieldsMap) {
        if (isInit && senders.containsKey(key) && fieldsMap != null && fieldsMap.size() > 0) {
            senders.get(key).put(eventName, fieldsMap);
        }
    }

    public void put(String eventName, Map<String, Object> fieldsMap) {
        if (this.forClientUse) {
            if (!this.bufferQueue.offer(new MetricMessage(eventName, fieldsMap)) && this.debug) {
                System.out.println("queue is full");
            }
        } else {
            try {
                this.bufferQueue.put(new MetricMessage(eventName, fieldsMap));
            }
            catch (InterruptedException e) {
                System.err.println(e.getCause().getMessage());
            }
        }
    }

    private void run() {
        while (true) {
            try {
                while (true) {
                    MetricMessage wrapperEntity;
                    if ((wrapperEntity = this.bufferQueue.poll(this.postBatchInterval, TimeUnit.MILLISECONDS)) != null) {
                        this.list.add(wrapperEntity);
                    }
                    if (this.list.size() < this.postBatchSize && (this.list.size() <= 0 || System.currentTimeMillis() - this.lastSendTimeMillis < (long)this.postBatchInterval)) continue;
                    this.sendAndClear();
                }
            }
            catch (Exception e) {
                if (!this.debug) continue;
                System.out.println(this.key + " : send data error:" + e.getMessage());
                continue;
            }
            break;
        }
    }

    private void sendAndClear() {
        this.triesTotal = this.maxTriesTotal;
        this.triesOnServer = this.maxTriesOnServer;
        this.sendWithLimitedTries();
        this.lastSendTimeMillis = System.currentTimeMillis();
        this.list.clear();
    }

    private void sendWithLimitedTries() {
        if (this.triesTotal > 0) {
            if (this.triesOnServer == 0) {
                this.nextServer();
            }
            if (!this.send()) {
                this.sendWithLimitedTries();
            }
        } else if (this.triesTotal == 0 && this.debug) {
            System.out.println(this.key + " : aborted after " + this.maxTriesTotal + " tries");
        } else {
            throw new IllegalStateException(this.key + " : bad tryTimes: triesOnServer: " + this.triesOnServer + "triesTotal: " + this.triesTotal);
        }
    }

    private void nextServer() {
        if (this.currentServer == -1) {
            this.currentServer = this.candidateServers.remove();
        } else {
            int lastServer = this.currentServer;
            this.currentServer = this.candidateServers.remove();
            this.candidateServers.offer(lastServer);
            this.triesOnServer = Math.min(this.maxTriesOnServer, this.triesTotal);
            if (this.debug) {
                System.out.println(this.key + " : server: [" + this.serverUrls[lastServer] + "] is not available, switched to  " + this.serverUrls[this.currentServer]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean send() {
        --this.triesOnServer;
        --this.triesTotal;
        URLConnection urlConnection = null;
        String serverUrl = this.serverUrls[this.currentServer];
        try {
            URL url = new URL(serverUrl + "/metric/batchpost/v1");
            urlConnection = (HttpURLConnection)url.openConnection();
            ((HttpURLConnection)urlConnection).setRequestMethod("POST");
            urlConnection.setReadTimeout(5000);
            urlConnection.setConnectTimeout(10000);
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConnection.setRequestProperty("charset", "utf-8");
            urlConnection.setRequestProperty("User-Agent", "Mercury Sender 1.0");
            urlConnection.setUseCaches(false);
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            OutputStream outputStream = urlConnection.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
            String value = Base64Util.getEncoder().encodeToString(DeflateUtil.compressStr(objectMapper.writeValueAsString(this.list)));
            HashMap<String, String> writeMap = new HashMap<String, String>();
            writeMap.put("value", value);
            writeMap.put("appId", this.appId);
            writeMap.put("appKey", this.appKey);
            writer.write(this.getPostDataString(writeMap));
            writer.flush();
            writer.close();
            outputStream.close();
            int responseCode = ((HttpURLConnection)urlConnection).getResponseCode();
            if (responseCode == 200) {
                if (this.debug) {
                    System.out.println(this.key + " : send package success, host: " + serverUrl + " size: " + this.list.size());
                }
                boolean bl = true;
                return bl;
            }
            if (this.debug) {
                System.out.println(this.key + " : send package error to host: " + serverUrl + "response code: " + responseCode + " size: " + this.list.size());
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (this.debug) {
                System.out.println(this.key + " : send package error to host: " + serverUrl + " exception: " + e + " size: " + this.list.size());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (urlConnection != null) {
                try {
                    urlConnection.getInputStream().close();
                    ((HttpURLConnection)urlConnection).disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getPostDataString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return result.toString();
    }
}

