package com.mfc.account.stub;

import com.mfc.account.model.req.*;
import com.mfc.account.model.rsp.AccountRegRsp;
import com.mfc.account.model.rsp.AccountInfoRsp;
import com.mfc.account.model.rsp.EmailBindingRsp;
import com.valor.mfc.vms.api.model.common.response.ResponseMsgList;
import com.valor.mfc.vms.api.model.common.response.ResponseMsgSingle;
import com.valor.mfc.vms.api.model.common.response.ResponseStatus;

import java.util.Map;

public interface AccountStub {

    /**
     * 注册用户
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgSingle<AccountRegRsp> registerAccount(Map<String, Object> stubProperties, AccountRegReq req);

    /**
     * 查询用户信息
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgSingle<AccountInfoRsp> queryAccount(Map<String, Object> stubProperties, AccountBaseReq req);


    /**
     * 查询用户信息
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgSingle<AccountInfoRsp> queryAccountV1(Map<String, Object> stubProperties, AccountBaseReq req);

    /**
     * login
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgSingle<AccountInfoRsp> loginAccount(Map<String, Object> stubProperties, AccountLoginReq req);

    /**
     * 重置密码
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus resetAccountPassword(Map<String, Object> stubProperties, AccountPasswordReq req);

    /**
     * 修改密码
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus changeAccountPassword(Map<String, Object> stubProperties, AccountPasswordReq req);


    ResponseStatus changeAccountPlan(Map<String, Object> stubProperties, AccountPlanReq req);

    ResponseStatus cancelRenewal(Map<String, Object> stubProperties, AccountPlanReq req);



    /**
     * 查询用户设备
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgList<AccountDevice> queryAccountDevice(Map<String, Object> stubProperties, AccountBaseReq req);

    /**
     * 支付通知
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus processPaymentNotification(Map<String, Object> stubProperties, PaymentNotificationReq req);

    /**
     * 直接修改用户的服务时长，不通过支付，用于CRM系统
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus modifyUserBiz(Map<String, Object> stubProperties, ModifyAccountBizReq req);

    /**
     * Activate Account
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus activateAccount(Map<String, Object> stubProperties, AccountRegReq req);

    /**
     * bindEmail
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus bindEmail(Map<String, Object> stubProperties, AccountBaseReq req);


    /**
     * activateEmailBindind
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus activateEmailBinding(Map<String, Object> stubProperties, AccountBaseReq req);

    /**
     * query email binding info
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseMsgSingle<EmailBindingRsp> checkEmailBinding(Map<String, Object> stubProperties, AccountBaseReq req);




    /**
     * set add cloud flag
     *
     * @param stubProperties
     * @param req
     * @return
     */
    ResponseStatus setAddCloudFlag(Map<String, Object> stubProperties, AccountBaseReq req);


}
