package com.mfc.account.stub;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.mfc.account.model.req.*;
import com.mfc.account.model.rsp.AccountInfoRsp;
import com.mfc.account.model.rsp.AccountRegRsp;
import com.mfc.account.model.rsp.EmailBindingRsp;
import com.valor.mfc.vms.api.model.common.response.ResponseMsgList;
import com.valor.mfc.vms.api.model.common.response.ResponseMsgSingle;
import com.valor.mfc.vms.api.model.common.response.ResponseStatus;
import common.base.tools.exception.ApiException;
import common.config.tools.config.ConfigTools3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;

public class AccountStubImpl implements AccountStub {

    private static final Logger logger = LoggerFactory.getLogger(AccountStubImpl.class);

    protected String host = ConfigTools3.getString("user3.api.host", "http://127.0.0.1:9712");
    private int timeout = ConfigTools3.getInt("user3.api.timeout", 60 * 1000); //60s

    private static final String API_URL_REGISTER_V1 = "/api/user3/register/v1";

    private static final String API_URL_CANC_ELRENEWAL_V1 = "/api/user3/cancel/renewal/v1";
    private static final String API_URL_QUERY_V1 = "/api/user3/queryUser/v1";
    private static final String API_URL_QUERY_ACCOUNT_V1 = "/api/user3/queryAccount/v1";

    private static final String API_URL_LOGIN_V1 = "/api/user3/login/v1";
    private static final String API_URL_QUERYDEVICE_V1 = "/api/user3/queryDevice/v1";
    private static final String API_URL_RESETPASSWORD_V1 = "/api/user3/resetPassword/v1";
    private static final String API_URL_MODIFYPASSWORD_V1 = "/api/user3/modifyPassword/v1";
    private static final String API_URL_NOTIFICATIONPAYMENTS_V1 = "/api/user3/notification/payments/v1";
    private static final String API_URL_CANCELRENEWAL_V1 = "/api/user3/notification/cancel/renewal/v1";
    private static final String API_URL_MODIFY_USER_BIZ_V1 = "/api/user3/modifyUserBiz/v1";
    private static final String API_URL_ACTIVATE_V1 = "/api/user3/activate/v1";
    private static final String API_URL_SET_ADD_CLOUD_FLAG_V1 = "/api/user3/setAddCloudFlag/v1";

    private static final String API_URL_UPDATE_PLAN_V1 = "/api/user3/updatePlan/v1";
    private static final String API_URL_CREATE_EMAIL_BINDING_V1 = "/api/user3/emailBinding/create/v1";
    private static final String API_URL_ACTIVATE_EMAIL_BINDING_V1 = "/api/user3/emailBinding/activate/v1";
    private static final String API_URL_QUERY_EMAIL_BINDING_V1 = "/api/user3/emailBinding/query/v1";

    private Object urlEncode(String encodeStr) {
        try {
            if (Objects.nonNull(encodeStr)) {
                return URLEncoder.encode(encodeStr, "UTF-8");
            }
        } catch (UnsupportedEncodingException e) {
            logger.error("URL encode error.[{}]", encodeStr, e);
        }
        return encodeStr;
    }

    @Override
    public ResponseMsgSingle<AccountRegRsp> registerAccount(Map<String, Object> stubProperties, AccountRegReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("userName", req.getUserName());
        dataMap.put("password", req.getPassword());
        ResponseMsgSingle<AccountRegRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_REGISTER_V1, timeout, dataMap, new TypeReference<ResponseMsgSingle<AccountRegRsp>>() {
            });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus cancelRenewal(Map<String, Object> stubProperties, AccountPlanReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);

        dataMap.put("pid", req.getProductId());
        dataMap.put("uid", req.getPaymentId());
        ResponseMsgSingle<AccountRegRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_CANC_ELRENEWAL_V1, timeout, dataMap,
                    new TypeReference<ResponseMsgSingle<AccountRegRsp>>() {
            });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> queryAccount(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("appVer", req.getAppVer());
        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_QUERY_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> queryAccountV1(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("callerType", req.getCallerType());
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("appVer", req.getAppVer());
        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_QUERY_ACCOUNT_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> loginAccount(Map<String, Object> stubProperties, AccountLoginReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("password", req.getPassword());
        dataMap.put("appBizExpire", req.getAppBizExpire());
        dataMap.put("model", req.getModel());
        dataMap.put("productId", req.getProductId());
        dataMap.put("plan", req.getPlan());
        dataMap.put("needAddCloud", req.isNeedAddCloud());
        dataMap.put("appVer", req.getAppVer());
        dataMap.put("vendorId", req.getVendorId());
        dataMap.put("mac", req.getMac());
        dataMap.put("cpuId", req.getCpuId());
        dataMap.put("imeiId", req.getImeiId());
        dataMap.put("client", req.getClient());
        dataMap.put("transferServiceTimeFlag", req.isTransferServiceTimeFlag());
        dataMap.put("langWeb", req.getLangWeb());
        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_LOGIN_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }


    @Override
    public ResponseMsgSingle<EmailBindingRsp> checkEmailBinding(Map<String, Object> stubProperties, AccountBaseReq
        req) {

        Map<String, Object> dataMap = Maps.newHashMap();

        dataMap.put("accountId", req.getAccountId1());
        dataMap.put("accountType",req.getAccountType());


        ResponseMsgSingle<EmailBindingRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_QUERY_EMAIL_BINDING_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<EmailBindingRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;

    }

    @Override
    public ResponseStatus activateEmailBinding(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();

        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("email", urlEncode(req.getEmail()));

        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_ACTIVATE_EMAIL_BINDING_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus bindEmail(Map<String, Object> stubProperties, AccountBaseReq req) {

        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();

        dataMap.put("endUserIp", req.getEndUserIp());
        dataMap.put("endUserRegion", req.getEndUserRegion());
        dataMap.put("clientType", req.getClientType());
        dataMap.put("did", req.getDid());
       // dataMap.put("accountId", req.getAccountId());
        dataMap.put("accountId", Long.valueOf(req.getAccountId1()));
        dataMap.put("accountId1", Long.valueOf(req.getAccountId1()));
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("loginId", urlEncode(req.getLoginId()));
        dataMap.put("email", urlEncode(req.getEmail()));

        ResponseMsgSingle<AccountInfoRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_CREATE_EMAIL_BINDING_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus resetAccountPassword(Map<String, Object> stubProperties, AccountPasswordReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("newPassword", req.getNewPassword());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_RESETPASSWORD_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }


    @Override
    public ResponseStatus changeAccountPlan(Map<String, Object> stubProperties, AccountPlanReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("uid", req.getUid());
        dataMap.put("productId", req.getProductId());
        dataMap.put("paymentId",req.getPaymentId());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_UPDATE_PLAN_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;


    }

    @Override
    public ResponseStatus changeAccountPassword(Map<String, Object> stubProperties, AccountPasswordReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("oldPassword", req.getOldPassword());
        dataMap.put("newPassword", req.getNewPassword());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_MODIFYPASSWORD_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountInfoRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgList<AccountDevice> queryAccountDevice(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("uid", req.getUid());
        ResponseMsgList<AccountDevice> rsp = new ResponseMsgList<>();
        try {
            rsp = invoke(host, API_URL_QUERYDEVICE_V1, timeout, dataMap,
                new TypeReference<ResponseMsgList<AccountDevice>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus processPaymentNotification(Map<String, Object> stubProperties, PaymentNotificationReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("accountId", urlEncode(Strings.nullToEmpty(req.getAccountId())));
        dataMap.put("paymentId", req.getPaymentId());
        dataMap.put("invoiceId", req.getInvoiceId());
        dataMap.put("uid", req.getUid());
        dataMap.put("orderId", req.getOrderId());
        dataMap.put("product", Strings.nullToEmpty(req.getProduct()));
        dataMap.put("productId", req.getProductId());
        dataMap.put("renewal", req.isRenewal());
        dataMap.put("amount", req.getAmount());
        dataMap.put("currency", Strings.nullToEmpty(req.getCurrency()));
        dataMap.put("serviceTs", req.getServiceTs());
        dataMap.put("serviceDays", req.getServiceDays());
        dataMap.put("deviceLimit", req.getDeviceLimit());
        dataMap.put("remark", req.getRemark());
        dataMap.put("action", req.getAction());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_NOTIFICATIONPAYMENTS_V1, timeout, dataMap,
                new TypeReference<ResponseStatus>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }


    @Override
    public ResponseStatus modifyUserBiz(Map<String, Object> stubProperties, ModifyAccountBizReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        dataMap.put("account", Strings.nullToEmpty(req.getAccount()));
        dataMap.put("serviceDays", req.getServiceDays());
        dataMap.put("action", req.getAction());
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("loginId", Strings.nullToEmpty(req.getLoginId()));
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_MODIFY_USER_BIZ_V1, timeout, dataMap,
                new TypeReference<ResponseStatus>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountRegRsp> activateAccount(Map<String, Object> stubProperties, AccountRegReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("email", urlEncode(req.getEmail()));
        ResponseMsgSingle<AccountRegRsp> rsp = new ResponseMsgSingle<>();
        try {
            rsp = invoke(host, API_URL_ACTIVATE_V1, timeout, dataMap,
                new TypeReference<ResponseMsgSingle<AccountRegRsp>>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus setAddCloudFlag(Map<String, Object> stubProperties, AccountBaseReq req) {
        updateStubInfo(stubProperties);
        Map<String, Object> dataMap = Maps.newHashMap();
        updateClientInfo(req, dataMap);
        dataMap.put("accountId1", req.getAccountId1());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = invoke(host, API_URL_SET_ADD_CLOUD_FLAG_V1, timeout, dataMap,
                new TypeReference<ResponseStatus>() {
                });
        } catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getTimeout() {
        return timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public AccountStubImpl(String host, int timeout) {
        this.host = host;
        this.timeout = timeout;
    }

    public AccountStubImpl(String host) {
        this.host = host;
    }

    public AccountStubImpl() {
    }

    private void updateStubInfo(Map<String, Object> stubProperties) {
        host = (String) stubProperties.getOrDefault(EAccountStubProperty.REQ_HOST.name(), this.host);
        timeout = (Integer) stubProperties.getOrDefault(EAccountStubProperty.REQ_TIMEOUT, this.timeout);
    }

    private void updateClientInfo(AccountBaseReq req, Map<String, Object> dataMap) {
        dataMap.put("endUserIp", req.getEndUserIp());
        dataMap.put("endUserRegion", req.getEndUserRegion());
        dataMap.put("clientType", req.getClientType());
        dataMap.put("did", req.getDid());
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("email", urlEncode(req.getEmail()));
    }


    private <T> T invoke(String host, String path, int timeout, Map<String, Object> dataMap,
        TypeReference typeReference) throws ApiException {
        String url = HttpInvokeTools.buildQueryUrl(host, path, dataMap);
        String responseBody = HttpInvokeTools.getInvoke(url, timeout);
        return HttpInvokeTools.httpResponse2Object(responseBody, typeReference);
    }

    private <T> T post(String host, String path, int timeout, Map<String, Object> dataMap,
        TypeReference typeReference) throws ApiException {
        String url = HttpInvokeTools.buildQueryUrl(host, path, dataMap);
        String responseBody = HttpInvokeTools.postInvoke(url, timeout, Maps.newHashMap());
        return HttpInvokeTools.httpResponse2Object(responseBody, typeReference);
    }

}
