/*
 * Decompiled with CFR 0.152.
 */
package com.mfc.account.stub;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.mfc.account.model.req.AccountBaseReq;
import com.mfc.account.model.req.AccountLoginReq;
import com.mfc.account.model.req.AccountPasswordReq;
import com.mfc.account.model.req.AccountPlanReq;
import com.mfc.account.model.req.AccountRegReq;
import com.mfc.account.model.req.ModifyAccountBizReq;
import com.mfc.account.model.req.PaymentNotificationReq;
import com.mfc.account.model.rsp.AccountInfoRsp;
import com.mfc.account.model.rsp.AccountRegRsp;
import com.mfc.account.model.rsp.EmailBindingRsp;
import com.mfc.account.stub.AccountDevice;
import com.mfc.account.stub.AccountStub;
import com.mfc.account.stub.EAccountStubProperty;
import com.mfc.account.stub.HttpInvokeTools;
import com.valor.mfc.vms.api.model.common.response.ResponseMsgList;
import com.valor.mfc.vms.api.model.common.response.ResponseMsgSingle;
import com.valor.mfc.vms.api.model.common.response.ResponseStatus;
import common.base.tools.exception.ApiException;
import common.config.tools.config.ConfigTools3;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountStubImpl
implements AccountStub {
    private static final Logger logger = LoggerFactory.getLogger(AccountStubImpl.class);
    protected String host = ConfigTools3.getString((String)"user3.api.host", (String)"http://127.0.0.1:9712");
    private int timeout = ConfigTools3.getInt((String)"user3.api.timeout", (Integer)60000);
    private static final String API_URL_REGISTER_V1 = "/api/user3/register/v1";
    private static final String API_URL_CANC_ELRENEWAL_V1 = "/api/user3/cancel/renewal/v1";
    private static final String API_URL_QUERY_V1 = "/api/user3/queryUser/v1";
    private static final String API_URL_QUERY_ACCOUNT_V1 = "/api/user3/queryAccount/v1";
    private static final String API_URL_LOGIN_V1 = "/api/user3/login/v1";
    private static final String API_URL_QUERYDEVICE_V1 = "/api/user3/queryDevice/v1";
    private static final String API_URL_RESETPASSWORD_V1 = "/api/user3/resetPassword/v1";
    private static final String API_URL_MODIFYPASSWORD_V1 = "/api/user3/modifyPassword/v1";
    private static final String API_URL_NOTIFICATIONPAYMENTS_V1 = "/api/user3/notification/payments/v1";
    private static final String API_URL_CANCELRENEWAL_V1 = "/api/user3/notification/cancel/renewal/v1";
    private static final String API_URL_MODIFY_USER_BIZ_V1 = "/api/user3/modifyUserBiz/v1";
    private static final String API_URL_ACTIVATE_V1 = "/api/user3/activate/v1";
    private static final String API_URL_SET_ADD_CLOUD_FLAG_V1 = "/api/user3/setAddCloudFlag/v1";
    private static final String API_URL_UPDATE_PLAN_V1 = "/api/user3/updatePlan/v1";
    private static final String API_URL_CREATE_EMAIL_BINDING_V1 = "/api/user3/emailBinding/create/v1";
    private static final String API_URL_ACTIVATE_EMAIL_BINDING_V1 = "/api/user3/emailBinding/activate/v1";
    private static final String API_URL_QUERY_EMAIL_BINDING_V1 = "/api/user3/emailBinding/query/v1";

    private Object urlEncode(String encodeStr) {
        try {
            if (Objects.nonNull(encodeStr)) {
                return URLEncoder.encode(encodeStr, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("URL encode error.[{}]", (Object)encodeStr, (Object)e);
        }
        return encodeStr;
    }

    @Override
    public ResponseMsgSingle<AccountRegRsp> registerAccount(Map<String, Object> stubProperties, AccountRegReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        this.updateClientInfo(req, dataMap);
        dataMap.put("email", this.urlEncode(req.getEmail()));
        dataMap.put("userName", req.getUserName());
        dataMap.put("password", req.getPassword());
        ResponseMsgSingle rsp = new ResponseMsgSingle();
        try {
            rsp = (ResponseMsgSingle)this.invoke(this.host, API_URL_REGISTER_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseMsgSingle<AccountRegRsp>>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus cancelRenewal(Map<String, Object> stubProperties, AccountPlanReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        this.updateClientInfo(req, dataMap);
        dataMap.put("pid", req.getProductId());
        dataMap.put("uid", req.getPaymentId());
        ResponseMsgSingle rsp = new ResponseMsgSingle();
        try {
            rsp = (ResponseMsgSingle)this.invoke(this.host, API_URL_CANC_ELRENEWAL_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseMsgSingle<AccountRegRsp>>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> queryAccount(Map<String, Object> stubProperties, AccountBaseReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        this.updateClientInfo(req, dataMap);
        dataMap.put("email", this.urlEncode(req.getEmail()));
        dataMap.put("loginId", this.urlEncode(req.getLoginId()));
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("appVer", req.getAppVer());
        ResponseMsgSingle rsp = new ResponseMsgSingle();
        try {
            rsp = (ResponseMsgSingle)this.invoke(this.host, API_URL_QUERY_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseMsgSingle<AccountInfoRsp>>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> queryAccountV1(Map<String, Object> stubProperties, AccountBaseReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        this.updateClientInfo(req, dataMap);
        dataMap.put("email", this.urlEncode(req.getEmail()));
        dataMap.put("loginId", this.urlEncode(req.getLoginId()));
        dataMap.put("callerType", req.getCallerType());
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("appVer", req.getAppVer());
        ResponseMsgSingle rsp = new ResponseMsgSingle();
        try {
            rsp = (ResponseMsgSingle)this.invoke(this.host, API_URL_QUERY_ACCOUNT_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseMsgSingle<AccountInfoRsp>>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<AccountInfoRsp> loginAccount(Map<String, Object> stubProperties, AccountLoginReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        this.updateClientInfo(req, dataMap);
        dataMap.put("loginId", this.urlEncode(req.getLoginId()));
        dataMap.put("email", this.urlEncode(req.getEmail()));
        dataMap.put("password", req.getPassword());
        dataMap.put("appBizExpire", req.getAppBizExpire());
        dataMap.put("model", req.getModel());
        dataMap.put("productId", req.getProductId());
        dataMap.put("plan", req.getPlan());
        dataMap.put("needAddCloud", req.isNeedAddCloud());
        dataMap.put("appVer", req.getAppVer());
        dataMap.put("vendorId", req.getVendorId());
        dataMap.put("mac", req.getMac());
        dataMap.put("cpuId", req.getCpuId());
        dataMap.put("imeiId", req.getImeiId());
        dataMap.put("client", req.getClient());
        dataMap.put("transferServiceTimeFlag", req.isTransferServiceTimeFlag());
        dataMap.put("langWeb", req.getLangWeb());
        ResponseMsgSingle rsp = new ResponseMsgSingle();
        try {
            rsp = (ResponseMsgSingle)this.invoke(this.host, API_URL_LOGIN_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseMsgSingle<AccountInfoRsp>>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgSingle<EmailBindingRsp> checkEmailBinding(Map<String, Object> stubProperties, AccountBaseReq req) {
        HashMap dataMap = Maps.newHashMap();
        dataMap.put("accountId", req.getAccountId1());
        dataMap.put("accountType", req.getAccountType());
        ResponseMsgSingle rsp = new ResponseMsgSingle();
        try {
            rsp = (ResponseMsgSingle)this.invoke(this.host, API_URL_QUERY_EMAIL_BINDING_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseMsgSingle<EmailBindingRsp>>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus activateEmailBinding(Map<String, Object> stubProperties, AccountBaseReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("loginId", this.urlEncode(req.getLoginId()));
        dataMap.put("email", this.urlEncode(req.getEmail()));
        ResponseMsgSingle rsp = new ResponseMsgSingle();
        try {
            rsp = (ResponseMsgSingle)this.invoke(this.host, API_URL_ACTIVATE_EMAIL_BINDING_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseMsgSingle<AccountInfoRsp>>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus bindEmail(Map<String, Object> stubProperties, AccountBaseReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        dataMap.put("endUserIp", req.getEndUserIp());
        dataMap.put("endUserRegion", req.getEndUserRegion());
        dataMap.put("clientType", req.getClientType());
        dataMap.put("did", req.getDid());
        dataMap.put("accountId", req.getAccountId1());
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("loginId", this.urlEncode(req.getLoginId()));
        dataMap.put("email", this.urlEncode(req.getEmail()));
        ResponseMsgSingle rsp = new ResponseMsgSingle();
        try {
            rsp = (ResponseMsgSingle)this.invoke(this.host, API_URL_CREATE_EMAIL_BINDING_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseMsgSingle<AccountInfoRsp>>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus resetAccountPassword(Map<String, Object> stubProperties, AccountPasswordReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        this.updateClientInfo(req, dataMap);
        dataMap.put("email", this.urlEncode(req.getEmail()));
        dataMap.put("newPassword", req.getNewPassword());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = (ResponseStatus)this.invoke(this.host, API_URL_RESETPASSWORD_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseMsgSingle<AccountInfoRsp>>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus changeAccountPlan(Map<String, Object> stubProperties, AccountPlanReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        this.updateClientInfo(req, dataMap);
        dataMap.put("uid", req.getUid());
        dataMap.put("productId", req.getProductId());
        dataMap.put("paymentId", req.getPaymentId());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = (ResponseStatus)this.invoke(this.host, API_URL_UPDATE_PLAN_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseMsgSingle<AccountInfoRsp>>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus changeAccountPassword(Map<String, Object> stubProperties, AccountPasswordReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        this.updateClientInfo(req, dataMap);
        dataMap.put("email", this.urlEncode(req.getEmail()));
        dataMap.put("oldPassword", req.getOldPassword());
        dataMap.put("newPassword", req.getNewPassword());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = (ResponseStatus)this.invoke(this.host, API_URL_MODIFYPASSWORD_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseMsgSingle<AccountInfoRsp>>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseMsgList<AccountDevice> queryAccountDevice(Map<String, Object> stubProperties, AccountBaseReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        this.updateClientInfo(req, dataMap);
        dataMap.put("email", this.urlEncode(req.getEmail()));
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("uid", req.getUid());
        ResponseMsgList rsp = new ResponseMsgList();
        try {
            rsp = (ResponseMsgList)this.invoke(this.host, API_URL_QUERYDEVICE_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseMsgList<AccountDevice>>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus processPaymentNotification(Map<String, Object> stubProperties, PaymentNotificationReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        dataMap.put("accountId", this.urlEncode(Strings.nullToEmpty((String)req.getAccountId())));
        dataMap.put("paymentId", req.getPaymentId());
        dataMap.put("invoiceId", req.getInvoiceId());
        dataMap.put("uid", req.getUid());
        dataMap.put("orderId", req.getOrderId());
        dataMap.put("product", Strings.nullToEmpty((String)req.getProduct()));
        dataMap.put("productId", req.getProductId());
        dataMap.put("renewal", req.isRenewal());
        dataMap.put("amount", req.getAmount());
        dataMap.put("currency", Strings.nullToEmpty((String)req.getCurrency()));
        dataMap.put("serviceTs", req.getServiceTs());
        dataMap.put("serviceDays", req.getServiceDays());
        dataMap.put("deviceLimit", req.getDeviceLimit());
        dataMap.put("remark", req.getRemark());
        dataMap.put("action", req.getAction());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = (ResponseStatus)this.invoke(this.host, API_URL_NOTIFICATIONPAYMENTS_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseStatus>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus modifyUserBiz(Map<String, Object> stubProperties, ModifyAccountBizReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        dataMap.put("account", Strings.nullToEmpty((String)req.getAccount()));
        dataMap.put("serviceDays", req.getServiceDays());
        dataMap.put("action", req.getAction());
        dataMap.put("accountType", req.getAccountType());
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("accountId1", req.getAccountId1());
        dataMap.put("loginId", Strings.nullToEmpty((String)req.getLoginId()));
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = (ResponseStatus)this.invoke(this.host, API_URL_MODIFY_USER_BIZ_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseStatus>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    public ResponseMsgSingle<AccountRegRsp> activateAccount(Map<String, Object> stubProperties, AccountRegReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        this.updateClientInfo(req, dataMap);
        dataMap.put("email", this.urlEncode(req.getEmail()));
        ResponseMsgSingle rsp = new ResponseMsgSingle();
        try {
            rsp = (ResponseMsgSingle)this.invoke(this.host, API_URL_ACTIVATE_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseMsgSingle<AccountRegRsp>>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    @Override
    public ResponseStatus setAddCloudFlag(Map<String, Object> stubProperties, AccountBaseReq req) {
        this.updateStubInfo(stubProperties);
        HashMap dataMap = Maps.newHashMap();
        this.updateClientInfo(req, dataMap);
        dataMap.put("accountId1", req.getAccountId1());
        ResponseStatus rsp = new ResponseStatus();
        try {
            rsp = (ResponseStatus)this.invoke(this.host, API_URL_SET_ADD_CLOUD_FLAG_V1, this.timeout, dataMap, (TypeReference)new TypeReference<ResponseStatus>(){});
        }
        catch (ApiException e) {
            rsp.setStatus(e.getRetCode(), e.getErrCode(), e.getMessage());
        }
        return rsp;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public AccountStubImpl(String host, int timeout) {
        this.host = host;
        this.timeout = timeout;
    }

    public AccountStubImpl(String host) {
        this.host = host;
    }

    public AccountStubImpl() {
    }

    private void updateStubInfo(Map<String, Object> stubProperties) {
        this.host = (String)stubProperties.getOrDefault(EAccountStubProperty.REQ_HOST.name(), this.host);
        this.timeout = (Integer)stubProperties.getOrDefault((Object)EAccountStubProperty.REQ_TIMEOUT, this.timeout);
    }

    private void updateClientInfo(AccountBaseReq req, Map<String, Object> dataMap) {
        dataMap.put("endUserIp", req.getEndUserIp());
        dataMap.put("endUserRegion", req.getEndUserRegion());
        dataMap.put("clientType", req.getClientType());
        dataMap.put("did", req.getDid());
        dataMap.put("accountId", req.getAccountId());
        dataMap.put("email", this.urlEncode(req.getEmail()));
    }

    private <T> T invoke(String host, String path, int timeout, Map<String, Object> dataMap, TypeReference typeReference) throws ApiException {
        String url = HttpInvokeTools.buildQueryUrl(host, path, dataMap);
        String responseBody = HttpInvokeTools.getInvoke(url, timeout);
        return HttpInvokeTools.httpResponse2Object(responseBody, typeReference);
    }

    private <T> T post(String host, String path, int timeout, Map<String, Object> dataMap, TypeReference typeReference) throws ApiException {
        String url = HttpInvokeTools.buildQueryUrl(host, path, dataMap);
        String responseBody = HttpInvokeTools.postInvoke(url, timeout, Maps.newHashMap());
        return HttpInvokeTools.httpResponse2Object(responseBody, typeReference);
    }
}

