package com.valor.mfc.vms.api.common.encrypt;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;

public class CRC32Checksum {
	private static final Logger logger = LoggerFactory.getLogger(CRC32Checksum.class);

	public final static long CRC32(String s) {
		try {
			return CRC32(s.getBytes("UTF-8"));
		} catch (UnsupportedEncodingException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
	}

	public final static long CRC32(byte[] bytes) {
		java.util.zip.CRC32 crc32 = new java.util.zip.CRC32();
		crc32.update(bytes);
		return crc32.getValue();
	}
}
