package com.valor.mfc.vms.api.common.encrypt;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import static com.valor.mfc.vms.api.common.encrypt.ByteHexUtils.byte2hex;

/**
 * Project     : volor
 * Description : MD5加密算法
 * Author      : Frank
 * Create Time : 2015/10/18 10:51
 * 
 * use guava Hashing.md5() replace.
 */
@Deprecated
public class MD5 {
    /**
     * MD5摘要算法
     * @param s
     * @return
     */

    private static final Logger logger = LoggerFactory.getLogger(MD5.class);
    MessageDigest digest = null;



    public MD5(){
        try {
            digest = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException e) {
            logger.error("MessageDigest",e);
        }
    }

    public void update(String str) throws UnsupportedEncodingException {
        if(digest != null){
            digest.update(str.getBytes("UTF-8"), 0, str.getBytes("UTF-8").length);
        }
    }

    public void update(byte[] bytes){
        if(digest != null){
            digest.update(bytes,0, bytes.length);
        }
    }

    public String checksum(){
        return byte2hex(digest.digest(),false);
    }

    public String base64Checksum(){
        return Base64Utils.encodeURLSafe(digest.digest());
    }


    public final static String MD5(String s) {
        try {
            return MD5(s.getBytes("UTF-8"));
        } catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public final static String MD5AsBase64(String s) {
        try {
            return MD5AsBase64(s.getBytes("UTF-8"));
        } catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public final static String MD5(byte[] bytes) {
        MD5 md5 = new MD5();
        md5.update(bytes);
        return md5.checksum();
    }

    public final static String MD5AsBase64(byte[] bytes) {
        MD5 md5 = new MD5();
        md5.update(bytes);
        return md5.base64Checksum();
    }
}
