package com.valor.mfc.vms.api.model.meta.media.v1;

/**
 * Created on 2021/11/30.
 *
 * @author Fagan Wang
 */
public enum EParentGuideLevel {
    /**
     * 严重程度，None
     */
    LEVEL_NONE(1, "None"),
    /**
     * 严重程度，Mild
     */
    LEVEL_MILD(2, "Mild"),
    /**
     * 严重程度，Moderate
     */
    LEVEL_MODERATE(3, "Moderate"),
    /**
     * 严重程度，Severe
     */
    LEVEL_SEVERE(4, "Severe");

    private Integer value;
    private String text;

    EParentGuideLevel(Integer value, String text) {
        this.value = value;
        this.text = text;
    }

    public static String getText(Integer value) {
        for (EParentGuideLevel eParentGuideLevel : EParentGuideLevel.values()) {
            if (eParentGuideLevel.getValue().equals(value)) {
                return eParentGuideLevel.name();
            }
        }
        return null;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }
}
