package com.valor.mfc.vms.api.model.constant;

/**
 * Created on 2022/1/25.
 *
 * @author Fagan Wang
 *
 * 列表展示样式
 */
public enum EDisplayType {
    /**
     * 列表页，左侧菜单+右侧列表（竖版）
     */
    TYPE_LIST_V1 ,
    /**
     * 列表页，左侧菜单+右侧列表（横板）
     */
    TYPE_LIST_V2 ,
    /**
     * 列表页，仅右侧列表（竖版）
     */
    TYPE_LIST_V3 ,
    /**
     * 列表页，仅右侧列表（横板）
     */
    TYPE_LIST_V4 ,
    /**
     * 专题类型
     */
    TYPE_LIST_TOPIC ;

    public static EDisplayType fromString(String type) {
        try {
            return EDisplayType.valueOf(type.trim().toUpperCase());
        } catch (IllegalArgumentException ex) {
            return null;
        }
    }
}
