package com.valor.mfc.vms.api.model.meta.base.v1;

import com.valor.mfc.vms.api.model.constant.EDisplayType;
import com.valor.mfc.vms.api.model.constant.EPlaylistType;
import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.api.model.meta.media.v1.CertificateDo;
import com.valor.mfc.vms.api.model.meta.media.v1.GenreDO;
import com.valor.mfc.vms.api.model.meta.media.v1.TrailerDO;
import com.valor.mfc.vms.api.model.tag.TagDo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * Project     : volor
 * Description :
 * Author      : Frank
 * Create Time : 2016/1/8 10:48
 */
public class BaseMetaDO extends ChargeDO {
    protected long       metaId;   //metaid,此处为内部id,后面使用displayId,做为app和服务端传输的参数。
    protected EVideoType metaType; //meta type
    protected String     vid="";   //vms展示id

    protected String title    = ""; //标题
    protected String poster   = "";  //海报
    protected String backdrop = "";  //背景
    protected double rating   = 0.0; //评分
    protected int    linked   = 0;   //是否链接
    protected String releaseDate;    //发行日期
    protected String lastAirDate;    //tv_series 最后更新日期

    protected String metaId2;        //metaId2,用于和linked关联,以'tt','mm','aa' 开头
    protected String logo = "";  //logo,列表logo
    protected String logo2 = "";  //logo2,列表logo2

    private String backgroundImage="";

    protected List<AwardDo> awards = new ArrayList<>();
    protected List<TagDo>   tags   = new ArrayList<>();
    protected Map<String, String> extra = new HashMap<>();

    protected String plot;
    protected List<GenreDO> genres = new ArrayList<>();

    /**
     * 2.3版本新增布局格式属性
     */
    private String layout;

    /**
     * 2.3版本新增音频语言
     */
    private List<String> audioLanguageList;

    /**
     * 2.3版本新增字幕语言
     */
    private List<String> subtitleList;

    /**
     * 2.3版本新增
     */
    private Map<String, CertificateDo> certificates = new HashMap<>();

    /**
     * 3.0版本新增，从PlaylistMetaDO中迁移过来
     */
    private EPlaylistType listType ;

    private List<TrailerDO> trailerList = new ArrayList<>();

    /**
     * 3.0版本新增展示类型，值为extra属性中displayType
     */
    private EDisplayType displayType;

    public String getPlot() {
        return plot;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    public long getMetaId() {
        return metaId;
    }

    public void setMetaId(long metaId) {
        this.metaId = metaId;
    }

    public EVideoType getMetaType() {
        return metaType;
    }

    public void setMetaType(EVideoType metaType) {
        this.metaType = metaType;
    }

    public void setMetaTypeInt(int metaType) {
        this.metaType = EVideoType.valueOf(metaType);
    }


    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public double getRating() {
        return rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }

    public int getLinked() {
        return linked;
    }

    public void setLinked(int linked) {
        this.linked = linked;
    }

    public String getPoster() {
        return poster;
    }

    public void setPoster(String poster) {
        this.poster = poster;
    }

    public String getBackdrop() {
        return backdrop;
    }

    public void setBackdrop(String backdrop) {
        this.backdrop = backdrop;
    }

    public String getVid() {
        return vid;
    }

    public void setVid(String vid) {
        this.vid = vid;
    }

    public List<AwardDo> getAwards() {
        return awards;
    }

    public void setAwards(List<AwardDo> awards) {
        this.awards = awards;
    }

    public String getReleaseDate() {
        return releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public String getLastAirDate() {
        return lastAirDate;
    }

    public void setLastAirDate(String lastAirDate) {
        this.lastAirDate = lastAirDate;
    }

    public String getMetaId2() {
        return metaId2;
    }

    public void setMetaId2(String metaId2) {
        this.metaId2 = metaId2;
    }

    public List<TagDo> getTags() {
        return tags;
    }

    public void addTags(List<TagDo> tagList){
        if (tagList!= null && tagList.size()> 0){
            for (TagDo e:tagList){
                if (!this.tags.contains(e)){
                    this.tags.add(e);
                }
            }
        }
    }

    public void setTags(List<TagDo> tags) {
        this.tags = tags;
    }

    public Map<String, String> getExtra() {
        return extra;
    }

    public void setExtra(Map<String, String> extra) {
        this.extra = extra;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BaseMetaDO that = (BaseMetaDO) o;
        return metaId == that.metaId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(metaId);
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getLogo2() {
        return logo2;
    }

    public void setLogo2(String logo2) {
        this.logo2 = logo2;
    }

    public String getBackgroundImage() {
        return backgroundImage;
    }

    public void setBackgroundImage(String backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public List<GenreDO> getGenres() {
        return genres;
    }

    public void setGenres(List<GenreDO> genres) {
        this.genres = genres;
    }

    public String getLayout() {
        return layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public List<String> getAudioLanguageList() {
        return audioLanguageList;
    }

    public void setAudioLanguageList(List<String> audioLanguageList) {
        this.audioLanguageList = audioLanguageList;
    }

    public List<String> getSubtitleList() {
        return subtitleList;
    }

    public void setSubtitleList(List<String> subtitleList) {
        this.subtitleList = subtitleList;
    }

    public Map<String, CertificateDo> getCertificates() {
        return certificates;
    }

    public void setCertificates(Map<String, CertificateDo> certificates) {
        this.certificates = certificates;
    }

    public List<TrailerDO> getTrailerList() {
        return trailerList;
    }

    public void setTrailerList(List<TrailerDO> trailerList) {
        this.trailerList = trailerList;
    }

    public EPlaylistType getListType() {
        return listType;
    }

    public void setListType(EPlaylistType listType) {
        this.listType = listType;
    }

    public EDisplayType getDisplayType() {
        return displayType;
    }

    public void setDisplayType(EDisplayType displayType) {
        this.displayType = displayType;
    }
}
