package com.common.web.aop.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation for api interface for mfc, do the common process,include:
 * 1. Convert and fill some request parameter
 * 2. Control request and response log
 * 3. Control response cache control
 * 4. Convert response(set http code:555) when request failed.
 * <p>
 * Created by Frank.Huang on 2017/1/17.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface WebApiCallV1 {
    /**
     * Minimum version support
     * Can use config:
     * webapi.version.min.{apiName}=xxxxxxx
     * if api not config,use webapi.version.min as default
     */
    int minVersion() default 0;

    /**
     * log level 0:off 1:on
     * Can use config:
     * webapi.log.level.{apiName}=0
     *   webapi.log.level.request.{apiName}=0
     *   webapi.log.level.response.{apiName}=0
     *
     */
    int logLevel() default 0;

    /**
     * Cache control about http response header field Cache-Control(Time unit:second)
     * Can use config:
     * webapi.cache.control.{apiName}=30
     */
    int cacheControl() default 0;

}
