package com.common.web.aop.processor;

import com.google.common.collect.ImmutableMap;
import com.valor.mfc.vms.api.model.common.response.ResponseStatus;
import com.valor.mfc.vms.api.model.constant.response.HttpCode2;
import com.valor.mfc.vms.api.model.user.EAccountType;
import com.valor.mfc.vms.common.tools.http.HttpConstant;
import com.valor.mfc.vms.common.web.request.BaseRequestArgs;
import common.session.service.SessionService;
import common.session.service.SessionServiceFactory;
import common.web.tools.http.model.response.WebApiBaseResponse;
import common.web.tools.http.model.response.WebApiResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * @author Arvin Zhang
 * @Description: 验证session是否失效，did + cpuId + androidId + imeiId
 * @date 2018/8/11 10:38
 **/
@Service
@Aspect
@Order(2)
public class VerifySessionInterceptor {

    private static final Logger logger = LoggerFactory.getLogger(VerifySessionInterceptor.class);


    @Pointcut(value = "@annotation(com.common.web.aop.annotation.VerifySession)")
    public void verifySession() {
    }

    @Around(value = "com.common.web.aop.processor.VerifySessionInterceptor.verifySession()")
    public Object doVerifySession(ProceedingJoinPoint pjp) throws Throwable {
        HttpServletRequest request = getRequest(pjp);
        HttpServletResponse response = getResponse(pjp);

        BaseRequestArgs args = getArgs(pjp);
        Object proceed = pjp.proceed();

//        if (args.isAppReq() && args.getAccountType() == EAccountType.ACCOUNT.ordinal()) {
        if (args.isAppReq()) {

            WebApiBaseResponse result = SessionServiceFactory.getSessionService().checkSession(args.getAccountType(), args.getAccountId(), args.getClientSession(), null);
            if (result.getErrCode() != 0) {
                response.setStatus(HttpCode2.SERVER_ERROR);
                if (proceed instanceof ResponseStatus) {
                    ResponseStatus responseStatus = (ResponseStatus) proceed;
                    responseStatus.setStatus(HttpCode2.RET_UNAUTHORIZED, HttpCode2.ERR_AUTH_CURRENT_ACCOUNT_ALREADY_OFFLINE, "Invalid session , user is not online ");
                }else if (proceed instanceof WebApiResponse){
                    ResponseStatus responseStatus = new ResponseStatus(HttpCode2.RET_UNAUTHORIZED, HttpCode2.ERR_AUTH_CURRENT_ACCOUNT_ALREADY_OFFLINE, "Invalid session , user is not online ");
                    return responseStatus;
                }

                logger.info("Account[{}] accountType[{}] session[{}] , session is not online ", args.getAccountId(), args.getAccountType(), args.getClientSession());
            } else {
                logger.info("Account[{}] accountType[{}] session[{}] , session is online ", args.getAccountId(), args.getAccountType(), args.getClientSession());
            }

        } else {
        logger.info("Account[{}] accountType[{}] session[{}] app[{}] device[{}] , don't check session ! ",

            args.getAccountId(), args.getAccountType(), args.getClientSession(), args.isAppReq(), args.getAccountType() == EAccountType.DEVICE.ordinal());
    }
        return proceed;
    }

    private HttpServletRequest getRequest(JoinPoint jp) {
        return (HttpServletRequest) jp.getArgs()[0];
    }

    private HttpServletResponse getResponse(JoinPoint jp) {
        return (HttpServletResponse) jp.getArgs()[1];
    }

    public BaseRequestArgs getArgs(JoinPoint jp) {
        Object arg = null;
        if (jp.getArgs().length >= 3) {
            arg = jp.getArgs()[2];
            if (arg instanceof BaseRequestArgs) {
                return (BaseRequestArgs) arg;
            }
        }
        return null;
    }
}
