package com.common.web.aop.processor;

import com.common.web.aop.annotation.WebApiAuthorizedIPOnly;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.valor.mfc.vms.api.exception.ApiException;
import com.valor.mfc.vms.api.model.constant.response.HttpCode2;
import com.valor.mfc.vms.common.tools.http.HttpTools;
import com.valor.mfc.vms.common.tools.type.CollectionUtils;
import com.valor.mfc.vms.common.web.tools.ArgTools;
import common.config.tools.config.ConfigTools3;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Set;

/**
 * Created by Frank.Huang on 2017/1/19.
 */
@Deprecated
@Aspect
@Service
public class WebApiAuthorizedIPOnlyInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(WebApiAuthorizedIPOnlyInterceptor.class);


    @Pointcut(value = "@annotation(com.common.web.aop.annotation.WebApiAuthorizedIPOnly)")
    public void webApiCallIpCheck() {
    }


    @Before(value = "com.common.web.aop.processor.WebApiAuthorizedIPOnlyInterceptor.webApiCallIpCheck()&&@annotation(wacic)")
    public void authIpCheck(JoinPoint jp, WebApiAuthorizedIPOnly wacic) throws ApiException {
        Set<String> authIps = Sets.newHashSet();

        String ips = wacic.authIps();
        String ipCfgName = wacic.authIpCfgName();
        if (!Strings.isNullOrEmpty(ips)) {
            authIps.addAll(ArgTools.getArgAsStringSet(ips));
        }

        if (!Strings.isNullOrEmpty(ipCfgName)) {
            List<String> authIpList = ConfigTools3.getAsList(ipCfgName);
            if (!CollectionUtils.isNullOrEmpty(authIpList)) {
                authIps.addAll(authIpList);
            }
        }

        if (CollectionUtils.isNullOrEmpty(authIps)) {
            return;
        }

        HttpServletRequest request = (HttpServletRequest) jp.getArgs()[0];
        String clientIp = HttpTools.getRemoteHost(request);
        if (!authIps.contains(clientIp)) {
            String msg = String.format("IP[%s] is not authorized", clientIp);
            logger.warn(msg);
            throw new ApiException(HttpCode2.RET_USER_BIZ, HttpCode2.ERR_BIZ_IP_IS_NOT_AUTHORIZED, "IP is not authorized");
        }
    }
}
