package com.common.web.crypt;

import com.google.common.base.Strings;

import common.config.tools.config.ConfigTools3;

/**
 * Created by Frank.Huang on 2017/5/29.
 */
public class CryptACL {
    private static String CRYPT_CONFIG_KEY = "mfc.api.crypt";
    private static String CRYPT_RESPONSE_ORI_KEY = "mfc.api.crypt.response.ori";

    private static String CRYPT_RESPONSE_CONTENT_TYPE_KEY = "mfc.api.crypt.response.contentType";

    private static String CRYPT_CONFIG_KEY_TIME_LOG = "mfc.api.crypt.debug.time";
    // public static boolean cryptTotalSwitch =
    // ConfigTools2.getAsBoolean(CRYPT_CONFIG_KEY,false);
    // public static boolean cryptTimeDebug =
    // ConfigTools2.getAsBoolean(CRYPT_CONFIG_KEY_TIME_LOG,false);

    public static boolean isContentTypeCrype(String contentType) {
        return ConfigTools3.getAsList(CRYPT_RESPONSE_CONTENT_TYPE_KEY).contains(contentType);
    }

    public static boolean isCryptEnable(String api) {
        return ConfigTools3.getBoolean(getCryptKey(api), ConfigTools3.getBoolean(CRYPT_CONFIG_KEY, false));
    }

    public static boolean isDebugTime() {
        return ConfigTools3.getBoolean(CRYPT_CONFIG_KEY_TIME_LOG, false);
    }

    private static String getCryptKey(String api) {
        return String.format("%s.%s", CRYPT_CONFIG_KEY, Strings.nullToEmpty(api));
    }

    public static boolean isResponseOri(String api) {
        return ConfigTools3.getBoolean(getCryptResKey(api),
            ConfigTools3.getBoolean(CRYPT_CONFIG_KEY, false) ? false : true);
    }

    private static String getCryptResKey(String api) {
        return String.format("%s.%s", CRYPT_RESPONSE_ORI_KEY, Strings.nullToEmpty(api));
    }

}
