package com.common.web.crypt;

import com.ijiami.AlgorithmType;
import com.ijiami.JMEncryptBox;
import com.ijiami.LoadMessage;
import com.valor.mfc.vms.api.common.encrypt.SHA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author hunter.zhu
 * @date 2019/6/26 15:56
 */
public class IjiamiSecurity {
    private static final Logger logger = LoggerFactory.getLogger(IjiamiSecurity.class);
    private  static int algorithmType= AlgorithmType.AES;
    private static boolean isLoadDllPath;


    /**
     * 加载爱加密文件,只需加载一次
     * @param cfgPath-文件夹路径
     */
    public static synchronized void init(String cfgPath) {
        if(isLoadDllPath){
            return ;
        }
        LoadMessage loadMessage = new LoadMessage() {
            @Override
            public void debugLoadMsg(String s) {
                logger.info(s);
            }
        };
       isLoadDllPath = JMEncryptBox.initLoadDllPath(cfgPath,loadMessage);
    }


    /**
     * 加密
     * @param plain
     * @return
     */
    public static String encryptString(String plain){
        logger.debug("encryptString plain[{}}",plain);
        String cipher = null;
        try {
            cipher = JMEncryptBox.encryptToBase64(plain,algorithmType);
        } catch (Exception e) {
            logger.error("encryptString plain exception:{}", e);
        }
        logger.debug("encryptString cipher[{}}",plain);
        return cipher;
    }

    /**
     * 解密
     * @param cipher
     * @return
     */
    public static String decryptString(String cipher){
        logger.debug("decryptString cipher[{}}",cipher);
        String plain= null;
        try {
            plain = JMEncryptBox.decryptFromBase64(cipher,algorithmType).getText();
        } catch (Exception e) {
            logger.error("decryptString cipher exception:{}", e);
        }
        logger.debug("decryptString plain[{}}",plain);
        return plain;

    }

    /**
     * cipher校验
     * @param message
     * @param signature
     * @return
     */
    public static boolean checkSign(String message,String signature){
        String sign = sign(message);
        boolean pass = sign.equals(signature);
        logger.debug("checkSign message[{}},signature[{}],sign[{}],[{}]",message,signature,sign,pass);
        return pass;
    }

    /**
     * 消息签名
     * @param message
     * @return
     */
    public static String sign(String message){
        return SHA.sha1(message);
    }
}
