package com.common.web.filter.sso;

import com.google.common.base.Strings;

import com.valor.mfc.vms.api.common.client.ActKey;
import com.valor.mfc.vms.api.common.client.SessionKey;
import com.valor.mfc.vms.api.common.encrypt.RSABase64Utils;
import com.valor.mfc.vms.api.model.constant.response.HttpCode2;
import com.valor.mfc.vms.common.tools.http.AppKeyConfig;
import com.valor.mfc.vms.common.tools.http.HttpConstant;
import com.valor.mfc.vms.common.tools.http.HttpTools;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by Frank.Huang on 2016/7/13.
 */
public class SSOSessionFilter extends AbstractSSOFilter {
    private static final Logger logger = LoggerFactory.getLogger(SSOSessionFilter.class);

    @Override
    public String getToken(HttpServletRequest httpRequest) {
        String token = HttpTools.getHttpParameter(httpRequest, HttpConstant.HTTP_ARG_ACT_KEY);
        if (Strings.isNullOrEmpty(token)){
            token = HttpTools.getHttpParameter(httpRequest, HttpConstant.HTTP_ARG_SESSION_KEY);
        }

        return token;
    }

    @Override
    public byte[] decryptToken(String token) {
        try {
            return RSABase64Utils.decryptByPrivateKey(token, AppKeyConfig.getAppkey());
        }catch (Exception e){
            logger.error("{}",e);
            return new byte[0];
        }
    }

    @Override
    public int verifyToken(HttpServletRequest httpRequest, Object object) {
        String host = HttpTools.getRemoteHost(httpRequest);

        if (object instanceof ActKey){
            ActKey actKey = (ActKey) object;
            String did = Strings.nullToEmpty(HttpTools.getHttpParameter(httpRequest, HttpConstant.HTTP_ARG_DID));
            if (!did.equalsIgnoreCase(actKey.getDid())){
                logger.error("==========HOST:[{}] MAC:[{}] Invalid did[{}]",host,did,actKey.getDid());
                return HttpCode2.ERR_AUTH_INVALID_DID;
            }

            httpRequest.setAttribute(HttpConstant.HTTP_REQ_ATTR_DID,     actKey.getDid());
            httpRequest.setAttribute(HttpConstant.HTTP_REQ_ATTR_USER_KEY,actKey.getSha1Pwd());
            httpRequest.setAttribute(HttpConstant.HTTP_REQ_ATTR_TOKEN,getToken(httpRequest));
            return HttpCode2.OK;
        }else if (object instanceof SessionKey){
            SessionKey sessionKey = (SessionKey) object;
            String did = Strings.nullToEmpty(HttpTools.getHttpParameter(httpRequest, HttpConstant.HTTP_ARG_DID));

            if (!did.equalsIgnoreCase(sessionKey.getDid())){
                logger.error("==========HOST:[{}] MAC:[{}] Invalid did[{}]",host,did,sessionKey.getDid());
                logger.error("==========HOST:[{}] QueryString[{}]",host,httpRequest.getQueryString());
                return HttpCode2.ERR_AUTH_INVALID_DID;
            }

            httpRequest.setAttribute(HttpConstant.HTTP_REQ_ATTR_TOKEN,getToken(httpRequest));
            return HttpCode2.OK;
        }else {
            logger.error("==========HOST:[{}] Invalid activate/session key",host);
            return HttpCode2.ERR_AUTH_INVALID_APPID;
        }
    }

    @Override
    public Object getTokenObj(HttpServletRequest httpRequest, byte[] bytes) {
        String apiPath = HttpTools.getApiPath(httpRequest);
        if (apiPath.startsWith("/api/uac/login")||apiPath.startsWith("/api/uac/logout")){
            return SessionKey.valueOf(bytes);
        }else {
            return ActKey.valueOf(bytes);
        }
    }

}
