/*
 * Decompiled with CFR 0.152.
 */
package com.common.web.aop.processor;

import com.valor.mfc.vms.api.model.common.response.ResponseStatus;
import com.valor.mfc.vms.common.tools.http.HttpTools;
import com.valor.mfc.vms.common.web.request.IRequestArgs;
import com.valor.mfc.vms.common.web.response.IResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtil {
    private static final Logger logger = LoggerFactory.getLogger(LogUtil.class);

    public static void logReq(HttpServletRequest request, IRequestArgs args) {
        logger.info("[REQ] [HOST]:[{}] [QUERY STRING]:[{}?{}] ARGS[{}]", new Object[]{HttpTools.getRemoteHost((HttpServletRequest)request), LogUtil.getRequestURL(request), LogUtil.getQueryString(request), args == null ? "-" : args.toString()});
    }

    public static void logRsp(String host, String apiName, IResponse response, IRequestArgs args) {
        logger.info("[RSP] [HOST]:[{}] [API]:[{}] Resp[{}] req[{}]", new Object[]{apiName, response, args == null ? "" : args.toString()});
    }

    public static void logRsp(String host, String apiName, IRequestArgs args, ResponseStatus response) {
        logger.info("[RSP] [API]:[{}] [{}]  ", (Object)apiName, (Object)response);
    }

    private static String getQueryString(HttpServletRequest request) {
        return request.getQueryString();
    }

    private static String getRequestURL(HttpServletRequest request) {
        return request.getRequestURI();
    }
}

