/*
 * Decompiled with CFR 0.152.
 */
package com.common.web.aop.processor;

import com.valor.mfc.vms.api.model.common.response.ResponseStatus;
import com.valor.mfc.vms.api.model.user.EAccountType;
import com.valor.mfc.vms.common.web.request.BaseRequestArgs;
import common.session.service.SessionServiceFactory;
import common.web.tools.http.model.response.WebApiBaseResponse;
import common.web.tools.http.model.response.WebApiResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Aspect
@Order(value=2)
public class VerifySessionInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(VerifySessionInterceptor.class);

    @Pointcut(value="@annotation(com.common.web.aop.annotation.VerifySession)")
    public void verifySession() {
    }

    @Around(value="com.common.web.aop.processor.VerifySessionInterceptor.verifySession()")
    public Object doVerifySession(ProceedingJoinPoint pjp) throws Throwable {
        HttpServletRequest request = this.getRequest((JoinPoint)pjp);
        HttpServletResponse response = this.getResponse((JoinPoint)pjp);
        BaseRequestArgs args = this.getArgs((JoinPoint)pjp);
        Object proceed = pjp.proceed();
        if (args.isAppReq()) {
            WebApiBaseResponse result = SessionServiceFactory.getSessionService().checkSession(Integer.valueOf(args.getAccountType()), Long.valueOf(args.getAccountId()), args.getClientSession(), null);
            if (result.getErrCode() != 0) {
                response.setStatus(555);
                if (proceed instanceof ResponseStatus) {
                    ResponseStatus responseStatus = (ResponseStatus)proceed;
                    responseStatus.setStatus(2, 225, "Invalid session , user is not online ");
                } else if (proceed instanceof WebApiResponse) {
                    ResponseStatus responseStatus = new ResponseStatus(2, 225, "Invalid session , user is not online ");
                    return responseStatus;
                }
                logger.info("Account[{}] accountType[{}] session[{}] , session is not online ", new Object[]{args.getAccountId(), args.getAccountType(), args.getClientSession()});
            } else {
                logger.info("Account[{}] accountType[{}] session[{}] , session is online ", new Object[]{args.getAccountId(), args.getAccountType(), args.getClientSession()});
            }
        } else {
            logger.info("Account[{}] accountType[{}] session[{}] app[{}] device[{}] , don't check session ! ", new Object[]{args.getAccountId(), args.getAccountType(), args.getClientSession(), args.isAppReq(), args.getAccountType() == EAccountType.DEVICE.ordinal()});
        }
        return proceed;
    }

    private HttpServletRequest getRequest(JoinPoint jp) {
        return (HttpServletRequest)jp.getArgs()[0];
    }

    private HttpServletResponse getResponse(JoinPoint jp) {
        return (HttpServletResponse)jp.getArgs()[1];
    }

    public BaseRequestArgs getArgs(JoinPoint jp) {
        Object arg = null;
        if (jp.getArgs().length >= 3 && (arg = jp.getArgs()[2]) instanceof BaseRequestArgs) {
            return (BaseRequestArgs)arg;
        }
        return null;
    }
}

