/*
 * Decompiled with CFR 0.152.
 */
package com.common.web.crypt.filter;

import com.common.web.crypt.CryptACL;
import com.common.web.crypt.CryptMsgTools;
import com.common.web.crypt.filter.RequestCryptWrapper;
import com.common.web.crypt.filter.ResponseCryptWrapper;
import com.common.web.crypt.model.ApiCryptMsg;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.valor.mfc.vms.common.tools.http.HttpTools;
import common.base.tools.sys.SystemTools;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class ResponseCryptFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(ResponseCryptFilter.class);
    private Gson gson = new Gson();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        RequestCryptWrapper reqWrapper = new RequestCryptWrapper(request);
        String v = reqWrapper.getParameter("v");
        String url = HttpTools.getRequestURI((HttpServletRequest)request);
        if (Strings.isNullOrEmpty((String)v) || CryptACL.isResponseOri(url)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            try (ServletOutputStream out = response.getOutputStream();){
                ResponseCryptWrapper wrapper = new ResponseCryptWrapper(response);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
                if (CryptACL.isContentTypeCrype(wrapper.getContentType())) {
                    out.write(wrapper.getData());
                } else {
                    String cryptMsg = this.getCryptMessage(url, v, wrapper.getData());
                    out.write(cryptMsg.getBytes("utf-8"));
                }
            }
        }
    }

    public void destroy() {
    }

    private String getCryptMessage(String url, String prot, byte[] data) throws IOException {
        boolean cryptEnable = CryptACL.isCryptEnable(url);
        ApiCryptMsg msg = new ApiCryptMsg();
        msg.setH(SystemTools.getHostnameMD5());
        msg.setT(System.currentTimeMillis());
        if (cryptEnable && (prot.equalsIgnoreCase("3") || prot.equalsIgnoreCase("4") || prot.equalsIgnoreCase("5"))) {
            msg.setV(prot);
            msg.setM(CryptMsgTools.encryptMsg(prot, data));
        } else {
            msg.setV("0");
            msg.setM(new String(data, "UTF-8"));
        }
        msg.setS(CryptMsgTools.getSign(prot, msg.getM()));
        return this.gson.toJson((Object)msg);
    }
}

