/*
 * Decompiled with CFR 0.152.
 */
package com.common.web.filter.sso;

import com.common.web.filter.sso.AbstractSSOFilter;
import com.google.common.base.Strings;
import com.valor.mfc.vms.api.common.client.ActKey;
import com.valor.mfc.vms.api.common.client.SessionKey;
import com.valor.mfc.vms.api.common.encrypt.RSABase64Utils;
import com.valor.mfc.vms.common.tools.http.AppKeyConfig;
import com.valor.mfc.vms.common.tools.http.HttpTools;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOSessionFilter
extends AbstractSSOFilter {
    private static final Logger logger = LoggerFactory.getLogger(SSOSessionFilter.class);

    @Override
    public String getToken(HttpServletRequest httpRequest) {
        String token = HttpTools.getHttpParameter((HttpServletRequest)httpRequest, (String)"actKey");
        if (Strings.isNullOrEmpty((String)token)) {
            token = HttpTools.getHttpParameter((HttpServletRequest)httpRequest, (String)"sessionKey");
        }
        return token;
    }

    @Override
    public byte[] decryptToken(String token) {
        try {
            return RSABase64Utils.decryptByPrivateKey((String)token, (String)AppKeyConfig.getAppkey());
        }
        catch (Exception e2) {
            logger.error("{}", (Throwable)e2);
            return new byte[0];
        }
    }

    @Override
    public int verifyToken(HttpServletRequest httpRequest, Object object) {
        String host = HttpTools.getRemoteHost((HttpServletRequest)httpRequest);
        if (object instanceof ActKey) {
            ActKey actKey = (ActKey)object;
            String did = Strings.nullToEmpty((String)HttpTools.getHttpParameter((HttpServletRequest)httpRequest, (String)"did"));
            if (!did.equalsIgnoreCase(actKey.getDid())) {
                logger.error("==========HOST:[{}] MAC:[{}] Invalid did[{}]", new Object[]{host, did, actKey.getDid()});
                return 202;
            }
            httpRequest.setAttribute("_did", (Object)actKey.getDid());
            httpRequest.setAttribute("_userKey", (Object)actKey.getSha1Pwd());
            httpRequest.setAttribute("_token", (Object)this.getToken(httpRequest));
            return 0;
        }
        if (object instanceof SessionKey) {
            SessionKey sessionKey = (SessionKey)object;
            String did = Strings.nullToEmpty((String)HttpTools.getHttpParameter((HttpServletRequest)httpRequest, (String)"did"));
            if (!did.equalsIgnoreCase(sessionKey.getDid())) {
                logger.error("==========HOST:[{}] MAC:[{}] Invalid did[{}]", new Object[]{host, did, sessionKey.getDid()});
                logger.error("==========HOST:[{}] QueryString[{}]", (Object)host, (Object)httpRequest.getQueryString());
                return 202;
            }
            httpRequest.setAttribute("_token", (Object)this.getToken(httpRequest));
            return 0;
        }
        logger.error("==========HOST:[{}] Invalid activate/session key", (Object)host);
        return 220;
    }

    @Override
    public Object getTokenObj(HttpServletRequest httpRequest, byte[] bytes) {
        String apiPath = HttpTools.getApiPath((HttpServletRequest)httpRequest);
        if (apiPath.startsWith("/api/uac/login") || apiPath.startsWith("/api/uac/logout")) {
            return SessionKey.valueOf((byte[])bytes);
        }
        return ActKey.valueOf((byte[])bytes);
    }
}

