/*
 * Decompiled with CFR 0.152.
 */
package com.common.web.filter.sso;

import com.common.web.filter.sso.AbstractSSOFilter;
import com.common.web.filter.sso.AuthTokenFiled;
import com.common.web.filter.sso.TokenV2;
import com.google.common.base.Strings;
import com.valor.mfc.vms.api.common.encrypt.RSABase64Utils;
import com.valor.mfc.vms.common.tools.http.ASKeyConfig;
import com.valor.mfc.vms.common.tools.http.HttpParameterTools;
import com.valor.mfc.vms.common.tools.http.HttpTools;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOTokenFilter
extends AbstractSSOFilter {
    private static final Logger logger = LoggerFactory.getLogger(SSOTokenFilter.class);

    @Override
    public String getToken(HttpServletRequest httpRequest) {
        return HttpParameterTools.getParameter((HttpServletRequest)httpRequest, (String)"token");
    }

    @Override
    public byte[] decryptToken(String token) {
        try {
            return RSABase64Utils.decryptByPublicKey((String)token, (String)ASKeyConfig.getAsKey());
        }
        catch (Exception e2) {
            logger.error("{}", (Throwable)e2);
            return new byte[0];
        }
    }

    @Override
    public int verifyToken(HttpServletRequest httpRequest, Object object) {
        String host = HttpTools.getRemoteHost((HttpServletRequest)httpRequest);
        if (object instanceof TokenV2) {
            String did;
            TokenV2 token = (TokenV2)object;
            logger.info("=======TokenV2-[{}]", (Object)token.toSerializeString());
            long curMS = System.currentTimeMillis();
            if (curMS >= token.getExpireTimestamp()) {
                logger.error("==========HOST:[{}] MAC:[{}] Token expire[{}-{}-{}]", new Object[]{host, token.getDid(), curMS, token.getExpireTimestamp(), token.getExpireTimestamp()});
                return 203;
            }
            Long uid = HttpParameterTools.getLongParameter((HttpServletRequest)httpRequest, (String)"uid");
            if (uid != null && uid > 0L && uid.longValue() != token.getDid2()) {
                logger.error("==========HOST:[{}] QueryString[{}]", (Object)host, (Object)httpRequest.getQueryString());
                logger.error("==========HOST:[{}] uid:[{}] INVALID UID[{}]", new Object[]{host, uid, token.getDid2()});
                return 205;
            }
            Long accountId = HttpParameterTools.getLongParameter((HttpServletRequest)httpRequest, (String)"accountId");
            if (accountId != null && accountId > 0L && accountId.longValue() != token.getAccountId().longValue()) {
                logger.error("==========HOST:[{}] QueryString[{}]", (Object)host, (Object)httpRequest.getQueryString());
                logger.error("==========HOST:[{}] uid:[{}] INVALID ACCOUNT ID[{}]", new Object[]{host, uid, token.getAccountId()});
                return 223;
            }
            if (token.getClientType() == 2 && (Strings.isNullOrEmpty((String)(did = HttpParameterTools.getParameter((HttpServletRequest)httpRequest, (String)"did"))) || !did.equalsIgnoreCase(token.getDid()))) {
                logger.error("==========HOST:[{}] MAC:[{}] Invalid Mac[{}]", new Object[]{host, did, token.getDid()});
                return 202;
            }
            httpRequest.setAttribute("_accountId", (Object)token.getAccountId());
            httpRequest.setAttribute("_did", (Object)token.getDid());
            httpRequest.setAttribute("_uid", (Object)token.getDid2());
            httpRequest.setAttribute("_ts", (Object)token.getGenerateTimestamp());
            httpRequest.setAttribute("_uprop", (Object)token.getUserProps());
            httpRequest.setAttribute("_token", (Object)this.getToken(httpRequest));
            httpRequest.setAttribute("accountType", token.get(AuthTokenFiled.ACCOUNT_TYPE.name()));
            if (token.getVersion() >= 20180808) {
                httpRequest.setAttribute("clientSession", token.get(AuthTokenFiled.CLIENT_SESSION.name()));
            }
            return 0;
        }
        logger.error("==========HOST:[{}] Invalid token", (Object)host);
        return 201;
    }

    @Override
    public Object getTokenObj(HttpServletRequest httpRequest, byte[] bytes) {
        return TokenV2.valueOf(bytes);
    }

    @Override
    public Set<String> getExcludedSet() {
        Set<String> excludedSet = super.getExcludedSet();
        excludedSet.add("/api/uac/login/v1");
        excludedSet.add("/api/uac/codeLogin/v1");
        excludedSet.add("/api/uac/activate/v1");
        excludedSet.add("/api/uac/activatedStatus/v1");
        excludedSet.add("/api/ns/*");
        excludedSet.add("/api/ping2");
        excludedSet.add("/api/uc/login4web/v1");
        excludedSet.add("/api/uc/login4app/v1");
        excludedSet.add("/api/uc/login4m/v1");
        excludedSet.add("/api/uc/register/v1");
        excludedSet.add("/api/uc/checkUser/v1");
        excludedSet.add("/api/uc/activateUser/v1");
        excludedSet.add("/api/uc/resetPassword/v1");
        excludedSet.add("/api/account/notice/setOnlineLimit/v1");
        return excludedSet;
    }
}

