/*
 * Decompiled with CFR 0.152.
 */
package com.common.web.tools;

import com.common.web.tools.GsonUtils;
import java.util.LinkedHashMap;
import org.slf4j.Logger;

public class LogJson {
    private static String buildLogStr(String description, Object ... entries) {
        LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>();
        maps.put("msg", description);
        for (int i = 0; i < entries.length; i += 2) {
            String key = String.valueOf(entries[i]);
            Object value = i + 1 >= entries.length ? "" : entries[i + 1];
            maps.put(key, (String)value);
        }
        return GsonUtils.getString(maps);
    }

    public static void info(Logger logger, String description, Object ... entries) {
        logger.info(LogJson.buildLogStr(description, entries));
    }

    public static void warn(Logger logger, String description, Object ... entries) {
        logger.warn(LogJson.buildLogStr(description, entries));
    }

    public static void error(Logger logger, Throwable throwable, String description, Object ... entries) {
        logger.error(LogJson.buildLogStr(description, entries), throwable);
    }

    public static void error(Logger logger, String description, Object ... entries) {
        logger.error(LogJson.buildLogStr(description, entries));
    }
}

