package com.mfc.es.api.model.client;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

/**
 * Created by Frank.Huang on 2017/3/16.
 */
public class ESProperties {
    @Deprecated
    public static final String CLUSTER_NAME = "clusterName";
    public static final String HOST = "serverHost";
    public static final String PORT = "serverPort";
    public static final String PROTOCOL = "serverProtocol";
    public static final String USER_NAME = "userName";
    public static final String PASSWORD = "password";

    public static final String BULK_SIZE = "bulkSize";
    public static final String BULK_BYTE_SIZE = "bulkByteSize";
    public static final String BULK_FLUSH_INTERVAL = "bulkFlushInterval";

    public static final String BULK_CONCURRENT = "bulkConcurrent";
    public static final String BULK_BACKOFF_INITIALDELAY = "bulkBackoffInitialdelay";
    public static final String BULK_BACKOFF_RETRY = "bulkBackoffRetry";


    public static final String LOG_PATH = "logPath";

    Map<String, Object> propertyMap = Maps.newHashMap();

    public static ESProperties builder() {
        return new ESProperties();
    }

    public ESProperties setProperty(String key, Object value) {
        propertyMap.put(key, value);
        return this;
    }

    public ESProperties clusterName(String clusterName) {
        return setProperty(CLUSTER_NAME, clusterName);
    }


    public ESProperties host(List<String> serverHost) {
        return setProperty(HOST, serverHost);
    }

    public ESProperties host(String serverHost) {
        List<String> serverHostList = (List<String>) propertyMap.get(HOST);
        if (serverHost != null) {
            serverHostList.add(serverHost);
        } else {
            propertyMap.put(HOST, ImmutableList.of(serverHost));
        }

        return this;
    }

    public ESProperties port(int serverPort) {
        return setProperty(PORT, serverPort);
    }

    public ESProperties protocol(String protocol) {
        return setProperty(PROTOCOL, protocol);
    }

    public ESProperties userName(String userName) {
        return setProperty(USER_NAME, userName);
    }

    public ESProperties password(String password) {
        return setProperty(PASSWORD, password);
    }

    public ESProperties bulkSize(int bulkSize) {
        return setProperty(BULK_SIZE, bulkSize);
    }

    public ESProperties bulkByteSize(int bulkByteSize) {
        return setProperty(BULK_BYTE_SIZE, bulkByteSize);
    }

    public ESProperties bulkFlushInterval(int bulkFlushInterval) {
        return setProperty(BULK_FLUSH_INTERVAL, bulkFlushInterval);
    }

    public ESProperties bulkConcurrent(int bulkConcurrent) {
        return setProperty(BULK_CONCURRENT, bulkConcurrent);
    }

    public ESProperties bulkBackoffInitialdelay(int bulkBackoffInitialdelay) {
        return setProperty(BULK_BACKOFF_INITIALDELAY, bulkBackoffInitialdelay);
    }

    public ESProperties bulkBackoffRetry(int bulkBackoffRetry) {
        return setProperty(BULK_BACKOFF_RETRY, bulkBackoffRetry);
    }


    public Object getProperty(String key) {
        return propertyMap.get(key);
    }

    public String getClusterName() {
        return (String) propertyMap.getOrDefault(CLUSTER_NAME, "");
    }

    public List<String> getHost(){
        return (List<String>) getProperty(HOST);
    }

    public int getPort() {
        return (Integer) propertyMap.get(PORT);
    }

    public String getProtocol() {
        return (String) propertyMap.getOrDefault(PROTOCOL, "");
    }

    public String getUserName() {
        return (String) propertyMap.getOrDefault(USER_NAME, "");
    }

    public String getPassword() {
        return (String) propertyMap.getOrDefault(PASSWORD, "");
    }


    public int bulkSize() {
        return (Integer) propertyMap.getOrDefault(BULK_SIZE,500);
    }

    public int bulkByteSize() {
        return (Integer) propertyMap.getOrDefault(BULK_BYTE_SIZE,10);
    }

    public int bulkFlushInterval() {
        return (Integer) propertyMap.getOrDefault(BULK_FLUSH_INTERVAL,10);
    }

    public int bulkConcurrent() {
        return (Integer) propertyMap.getOrDefault(BULK_CONCURRENT,10);
    }

    public int bulkBackoffInitialdelay() {
        return (Integer) propertyMap.getOrDefault(BULK_BACKOFF_INITIALDELAY,100);
    }

    
    public int bulkBackoffRetry() {
        return (Integer) propertyMap.getOrDefault(BULK_BACKOFF_RETRY,3);
    }
    

    public String getLogPath() {
        return (String) propertyMap.getOrDefault(LOG_PATH, "logs");
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
            .add("propertyMap", propertyMap)
            .toString();
    }
}
