package com.mfc.es.api.model.service.media;

import com.google.common.base.Objects;
import com.mfc.es.api.model.service.base.AbstractLocaleDoc;
import common.base.tools.encrypt.MD5Tools;
import common.base.tools.type.DdoKeyTools;
import org.elasticsearch.common.Strings;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;

/**
 * Created by Frank.Huang on 2017/3/6.
 */
public class MediaAward extends AbstractLocaleDoc {

    private Integer mediaType = 0;
    private String event;      // 活动
    private String category;   // 奖项
    private String organized;  // 组织者
    private String source;     // 举办地
    private int year;       // 年份
    private int wonOrNominated = 0;       // 是否获奖
    private Set<PersonName> persons = new LinkedHashSet();
    private Date createTime;

    public Integer getMediaType() {
        return mediaType;
    }

    public void setMediaType(Integer mediaType) {
        this.mediaType = mediaType;
    }

    public String getEvent() {
        return event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getOrganized() {
        return organized;
    }

    public void setOrganized(String organized) {
        this.organized = organized;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public int getYear() {
        return year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getWonOrNominated() {
        return wonOrNominated;
    }

    public void setWonOrNominated(int wonOrNominated) {
        this.wonOrNominated = wonOrNominated;
    }

    public Set<PersonName> getPersons() {
        return persons;
    }

    public void setPersons(Set<PersonName> persons) {
        this.persons = persons;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getDocumentId() {
        if (!Strings.isNullOrEmpty(documentId)) {
            return documentId;
        }
        return makeDocumentId(this.id, this.year, language, MD5Tools.hmacMd5(this.event + this.category));
    }
}
