package com.mfc.es.api.model.service.search;

import com.mfc.es.api.client.EESFilterType;
import com.mfc.es.api.model.service.base.AbstractPrintable;

/**
 * Created by Frank.Huang on 2017/3/20.
 */
public class ESRangeFilterBuilder extends AbstractPrintable implements IESFilterBuilder {
    private final String fieldName;
    private Object from;
    private Object to;
    private boolean includeLower = false;
    private boolean includeUpper = false;
    private EESFilterType filterType = EESFilterType.MUST;

    public static ESRangeFilterBuilder builder(String fieldName){
        return new ESRangeFilterBuilder(fieldName);
    }
    
    public ESRangeFilterBuilder setFilterType(EESFilterType filterType){
        this.filterType = filterType;
        return this;
    }

    public ESRangeFilterBuilder(String fieldName) {
        this.fieldName = fieldName;
    }


    public ESRangeFilterBuilder from(Object from, boolean includeLower) {
        this.from = from;
        this.includeLower = includeLower;
        return this;
    }

    public ESRangeFilterBuilder from(Object from) {
        return from(from, this.includeLower);
    }

    
    /**
     * The from part of the range query. Null indicates unbounded.
     */
    public ESRangeFilterBuilder gt(Object from) {
        return from(from, false);
    }

    /**
     * The from part of the range query. Null indicates unbounded.
     */
    public ESRangeFilterBuilder gte(Object from) {
        return from(from, true);
    }

    /**
     * The to part of the range query. Null indicates unbounded.
     */
    public ESRangeFilterBuilder to(Object to, boolean includeUpper) {
        this.to = to;
        this.includeUpper = includeUpper;
        return this;
    }

    /**
     * The to part of the range query. Null indicates unbounded.
     */
    public ESRangeFilterBuilder to(Object to) {
        return to(to, this.includeUpper);
    }


    /**
     * The to part of the range query. Null indicates unbounded.
     */
    public ESRangeFilterBuilder lt(Object to) {
        return to(to, false);
    }

    /**
     * The to part of the range query. Null indicates unbounded.
     */
    public ESRangeFilterBuilder lte(Object to) {
        return to(to, true);
    }

    /**
     * Should the lower bound be included or not. Defaults to <tt>true</tt>.
     */
    public ESRangeFilterBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    /**
     * Gets the includeLower flag for this query.
     */
    public boolean includeLower() {
        return this.includeLower;
    }

    /**
     * Should the upper bound be included or not. Defaults to <tt>true</tt>.
     */
    public ESRangeFilterBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }
    
    public String getFieldName() {
        return fieldName;
    }

    public Object getFrom() {
        return from;
    }

    public void setFrom(Object from) {
        this.from = from;
    }

    public Object getTo() {
        return to;
    }

    public void setTo(Object to) {
        this.to = to;
    }

    public boolean isIncludeLower() {
        return includeLower;
    }

    public void setIncludeLower(boolean includeLower) {
        this.includeLower = includeLower;
    }

    public boolean isIncludeUpper() {
        return includeUpper;
    }

    public void setIncludeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
    }

    public EESFilterType getFilterType() {
        return filterType;
    }
}
