/*
 * Decompiled with CFR 0.152.
 */
package com.mfc.es.api.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.mfc.es.api.client.ESIndexApi;
import com.mfc.es.api.model.client.ESProperties;
import com.mfc.es.api.model.service.base.IDocument;
import common.base.tools.JSON.JSONTools;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESApi {
    private static final Logger logger = LoggerFactory.getLogger(ESIndexApi.class);
    protected RestClient lowClient = null;
    protected RestHighLevelClient client = null;
    protected boolean bInit = false;
    protected ESProperties properties = null;

    public ESApi(ESProperties properties) {
        this.properties = properties;
        this.bInit = this.init();
    }

    public boolean init() {
        if (this.bInit && this.client != null) {
            return this.bInit;
        }
        logger.info("[ES-API]Connect[{}://{}:{}]", new Object[]{this.properties.getHost(), this.properties.getPort(), this.properties.getProtocol()});
        ArrayList hosts = Lists.newArrayList();
        this.properties.getHost().forEach(e -> hosts.add(new HttpHost(e, this.properties.getPort(), this.properties.getProtocol())));
        HttpHost[] hostArray = new HttpHost[this.properties.getHost().size()];
        hostArray = hosts.toArray(hostArray);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.properties.getUserName(), this.properties.getPassword()));
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])hostArray).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
            final /* synthetic */ CredentialsProvider val$credentialsProvider;
            {
                this.val$credentialsProvider = credentialsProvider;
            }

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
            }
        });
        this.lowClient = restClientBuilder.build();
        this.client = new RestHighLevelClient(restClientBuilder);
        return this.client != null;
    }

    public boolean hasInit() {
        return this.bInit;
    }

    public String toJson(IDocument doc) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return mapper.writer().writeValueAsString((Object)doc);
        }
        catch (IOException e) {
            logger.info("[ES-API]To json failed. doc:[{}] ex:[{}]", (Object)doc, (Object)e);
            return "";
        }
    }

    public <T> T fromJsonStr(String jsonStr, Class<T> clazz) {
        try {
            return (T)JSONTools.fromJson((String)jsonStr, clazz);
        }
        catch (IOException e) {
            logger.info("[ES-API]From json failed. doc:[{}] ex:[{}]", (Object)jsonStr, (Object)e);
            return null;
        }
    }
}

