/*
 * Decompiled with CFR 0.152.
 */
package com.mfc.es.api.model.service.search;

import com.mfc.es.api.client.EESFilterType;
import com.mfc.es.api.model.service.base.AbstractPrintable;
import com.mfc.es.api.model.service.search.IESFilterBuilder;

public class ESRangeFilterBuilder
extends AbstractPrintable
implements IESFilterBuilder {
    private final String fieldName;
    private Object from;
    private Object to;
    private boolean includeLower = false;
    private boolean includeUpper = false;
    private EESFilterType filterType = EESFilterType.MUST;

    public static ESRangeFilterBuilder builder(String fieldName) {
        return new ESRangeFilterBuilder(fieldName);
    }

    public ESRangeFilterBuilder setFilterType(EESFilterType filterType) {
        this.filterType = filterType;
        return this;
    }

    public ESRangeFilterBuilder(String fieldName) {
        this.fieldName = fieldName;
    }

    public ESRangeFilterBuilder from(Object from, boolean includeLower) {
        this.from = from;
        this.includeLower = includeLower;
        return this;
    }

    public ESRangeFilterBuilder from(Object from) {
        return this.from(from, this.includeLower);
    }

    public ESRangeFilterBuilder gt(Object from) {
        return this.from(from, false);
    }

    public ESRangeFilterBuilder gte(Object from) {
        return this.from(from, true);
    }

    public ESRangeFilterBuilder to(Object to, boolean includeUpper) {
        this.to = to;
        this.includeUpper = includeUpper;
        return this;
    }

    public ESRangeFilterBuilder to(Object to) {
        return this.to(to, this.includeUpper);
    }

    public ESRangeFilterBuilder lt(Object to) {
        return this.to(to, false);
    }

    public ESRangeFilterBuilder lte(Object to) {
        return this.to(to, true);
    }

    public ESRangeFilterBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public boolean includeLower() {
        return this.includeLower;
    }

    public ESRangeFilterBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getFrom() {
        return this.from;
    }

    public void setFrom(Object from) {
        this.from = from;
    }

    public Object getTo() {
        return this.to;
    }

    public void setTo(Object to) {
        this.to = to;
    }

    public boolean isIncludeLower() {
        return this.includeLower;
    }

    public void setIncludeLower(boolean includeLower) {
        this.includeLower = includeLower;
    }

    public boolean isIncludeUpper() {
        return this.includeUpper;
    }

    public void setIncludeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
    }

    public EESFilterType getFilterType() {
        return this.filterType;
    }
}

