package com.mfc.es.api.model.service.search;

import com.mfc.es.api.client.EESFilterType;
import com.mfc.es.api.model.service.base.AbstractPrintable;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
/**
 * @author hunter.zhu
 * @date 2019/7/12 13:42
 */
public class ESNestedFilterBuilder extends AbstractPrintable implements IESFilterBuilder {
    private final String path;
    BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
    ScoreMode scoreMode;
    private EESFilterType filterType = EESFilterType.MUST;
    public static ESNestedFilterBuilder builder(String path){
        return builder(path,ScoreMode.None);
    }

    public static ESNestedFilterBuilder builder(String path,ScoreMode scoreMod){
        return new ESNestedFilterBuilder(path,scoreMod);
    }
    public ESNestedFilterBuilder(String path,ScoreMode scoreMode) {
        this.path = path;
        this.scoreMode = scoreMode;
    }

    public ESNestedFilterBuilder add(IESFilterBuilder IESFilterBuilder){
        QueryBuilder queryBuilder = null;
        EESFilterType esFilterType = EESFilterType.MUST;
        if (IESFilterBuilder instanceof ESTermFilterBuilder) {
            ESTermFilterBuilder termFilter = (ESTermFilterBuilder) IESFilterBuilder;
            if (termFilter.isMultiValue() && termFilter.getValues() != null) {
                queryBuilder = QueryBuilders.termsQuery(termFilter.getFieldName(), termFilter.getValues());
            } else if(!termFilter.isMultiValue() && termFilter.getValue() != null) {
                queryBuilder = QueryBuilders.termQuery(termFilter.getFieldName(), termFilter.getValue());
            }
            esFilterType = termFilter.getFilterType();
        } else if (IESFilterBuilder instanceof ESRangeFilterBuilder) {
            ESRangeFilterBuilder rangeFilter = (ESRangeFilterBuilder) IESFilterBuilder;

            queryBuilder = QueryBuilders.rangeQuery(rangeFilter.getFieldName())
                    .from(rangeFilter.getFrom())
                    .to(rangeFilter.getTo())
                    .includeLower(rangeFilter.isIncludeLower())
                    .includeUpper(rangeFilter.isIncludeUpper());

            esFilterType = rangeFilter.getFilterType();
        }
        if (queryBuilder != null) {
            switch (esFilterType) {
                case MUST:
                    boolQueryBuilder.must(queryBuilder);
                    break;
                case SHOULD:
                    boolQueryBuilder.should(queryBuilder);
                    break;
                case MUST_NOT:
                    boolQueryBuilder.mustNot(queryBuilder);
                    break;
                default:
                    boolQueryBuilder.must(queryBuilder);
            }
        }
        return this;
    }


    public String getPath() {
        return path;
    }

    public BoolQueryBuilder getBoolQueryBuilder() {
        return boolQueryBuilder;
    }

    public ScoreMode getScoreMode() {
        return scoreMode;
    }
    public ESNestedFilterBuilder setFilterType(EESFilterType filterType){
        this.filterType = filterType;
        return this;
    }

    public EESFilterType getFilterType() {
        return filterType;
    }
}
