package com.mfc.es.api.model.service.search;

import com.google.common.collect.Sets;

import com.mfc.es.api.model.service.base.AbstractPrintable;
import common.config.tools.config.ConfigTools3;

import java.util.Set;

/**
 * Created by Frank.Huang on 2017/3/16.
 */
public class ESSearchParameter  extends AbstractPrintable {
    private String index;
    private String type;
    private int from;
    private int size;
    private Set<IESFilterBuilder> filters = Sets.newLinkedHashSet();
    private Set<ESOrder> orders = Sets.newLinkedHashSet();
    private boolean showAll = false;
    private int showUntilDate = 0;
    private boolean unLimitSize = false;

    public static ESSearchParameter builder(){
        return new ESSearchParameter();
    }

    public ESSearchParameter index(String index) {
        this.index = index;
        return this;
    }

    public ESSearchParameter type(String type) {
        this.type = type;
        return this;
    }
    public ESSearchParameter from(int from) {
        this.from = from;
        return this;
    }

    public ESSearchParameter size(int size) {
        this.size = size;
        return this;
    }

    public ESSearchParameter add(IESFilterBuilder filter){
        this.filters.add(filter);
        return this;
    }
    
    public ESSearchParameter add(ESOrder order){
        this.orders.add(order);
        return this;
    }

    public String getIndex() {
        return index;
    }

    public String getType() {
        return type;
    }

    public int getFrom() {
        if(unLimitSize){
            return from;
        }
        int max=ConfigTools3.getInt("es.max.result",10000);
        return Math.min(max,from);
    }

    public int getSize() {
        if(unLimitSize){
            return size;
        }
        int max=ConfigTools3.getInt("es.max.result",10000);
        return Math.min(max,size);
    }

    public Set<IESFilterBuilder> getFilters() {
        return filters;
    }

    public Set<ESOrder> getOrders() {
        return orders;
    }

    public boolean isShowAll() {
        return showAll;
    }

    public int getShowUntilDate() {
        return showUntilDate;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setFilters(Set<IESFilterBuilder> filters) {
        this.filters = filters;
    }

    public void setOrders(Set<ESOrder> orders) {
        this.orders = orders;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    public void setShowUntilDate(int showUntilDate) {
        this.showUntilDate = showUntilDate;
    }

    public void setUnLimitSize(boolean unLimitSize) {
        this.unLimitSize = unLimitSize;
    }
}
