/*
 * Decompiled with CFR 0.152.
 */
package com.mfc.es.api.client;

import com.google.common.collect.Lists;
import com.mfc.es.api.client.EESFilterType;
import com.mfc.es.api.client.ESApi;
import com.mfc.es.api.model.client.ESProperties;
import com.mfc.es.api.model.service.cloud.MediaCloud;
import com.mfc.es.api.model.service.cloud.MediaCloudSearchIndex;
import com.mfc.es.api.model.service.media.MediaAward;
import com.mfc.es.api.model.service.media.MediaBase;
import com.mfc.es.api.model.service.media.MediaDetail;
import com.mfc.es.api.model.service.media.MediaImage;
import com.mfc.es.api.model.service.media.MediaParentsGuide;
import com.mfc.es.api.model.service.media.MediaSearchIndex;
import com.mfc.es.api.model.service.media.MediaSummary;
import com.mfc.es.api.model.service.media.MediaSynopsis;
import com.mfc.es.api.model.service.media.MediaUserReview;
import com.mfc.es.api.model.service.person.Person;
import com.mfc.es.api.model.service.person.PersonSearchIndex;
import com.mfc.es.api.model.service.search.ESApiResponse;
import com.mfc.es.api.model.service.search.ESNestedFilterBuilder;
import com.mfc.es.api.model.service.search.ESRangeFilterBuilder;
import com.mfc.es.api.model.service.search.ESSearchParameter;
import com.mfc.es.api.model.service.search.ESTermFilterBuilder;
import com.mfc.es.api.model.service.search.IESFilterBuilder;
import common.base.tools.stat.TimeStatisticsTools;
import common.config.tools.config.ConfigTools3;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.adjacency.ParsedAdjacencyMatrix;
import org.elasticsearch.search.aggregations.bucket.composite.ParsedComposite;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilter;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilters;
import org.elasticsearch.search.aggregations.bucket.geogrid.ParsedGeoHashGrid;
import org.elasticsearch.search.aggregations.bucket.global.ParsedGlobal;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedHistogram;
import org.elasticsearch.search.aggregations.bucket.missing.ParsedMissing;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedReverseNested;
import org.elasticsearch.search.aggregations.bucket.range.ParsedBinaryRange;
import org.elasticsearch.search.aggregations.bucket.range.ParsedDateRange;
import org.elasticsearch.search.aggregations.bucket.range.ParsedGeoDistance;
import org.elasticsearch.search.aggregations.bucket.range.ParsedRange;
import org.elasticsearch.search.aggregations.bucket.sampler.ParsedSampler;
import org.elasticsearch.search.aggregations.bucket.significant.ParsedSignificantLongTerms;
import org.elasticsearch.search.aggregations.bucket.significant.ParsedSignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedDoubleTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.metrics.avg.ParsedAvg;
import org.elasticsearch.search.aggregations.metrics.cardinality.ParsedCardinality;
import org.elasticsearch.search.aggregations.metrics.geobounds.ParsedGeoBounds;
import org.elasticsearch.search.aggregations.metrics.geocentroid.ParsedGeoCentroid;
import org.elasticsearch.search.aggregations.metrics.max.ParsedMax;
import org.elasticsearch.search.aggregations.metrics.min.ParsedMin;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.ParsedHDRPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.ParsedHDRPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.ParsedTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.ParsedTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.scripted.ParsedScriptedMetric;
import org.elasticsearch.search.aggregations.metrics.stats.ParsedStats;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ParsedExtendedStats;
import org.elasticsearch.search.aggregations.metrics.sum.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.tophits.ParsedTopHits;
import org.elasticsearch.search.aggregations.metrics.valuecount.ParsedValueCount;
import org.elasticsearch.search.aggregations.pipeline.ParsedSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.ParsedBucketMetricValue;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.ParsedPercentilesBucket;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.ParsedStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.ParsedExtendedStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.derivative.ParsedDerivative;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestion;
import org.elasticsearch.search.suggest.term.TermSuggestion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESSearchApi
extends ESApi {
    private static final Logger logger = LoggerFactory.getLogger(ESSearchApi.class);
    private static final DeprecationHandler DEPRECATION_HANDLER = new DeprecationHandler(){

        public void usedDeprecatedName(String usedName, String modernName) {
        }

        public void usedDeprecatedField(String usedName, String replacedWith) {
        }
    };

    public ESSearchApi(ESProperties esProperties) {
        super(esProperties);
    }

    public <T> ESApiResponse<T> search(ESSearchParameter parameter) {
        long beginTime = System.currentTimeMillis();
        String queryJson = this.parseParameter(parameter);
        boolean printJson = ConfigTools3.getBoolean((String)"mfc.es.search.req.log.enabled", (boolean)false);
        if (printJson) {
            logger.info("[ESSearchApi][search] queryJson[{}]", (Object)queryJson);
        }
        logger.debug("[ESSearchApi][search] queryJson[{}]", (Object)queryJson);
        logger.debug("[ESSearchApi][search] parseParameter[{}]", (Object)(System.currentTimeMillis() - beginTime));
        try {
            NStringEntity entity = new NStringEntity(queryJson, ContentType.APPLICATION_JSON);
            Request request = new Request("POST", "/" + parameter.getIndex() + "/" + parameter.getType() + "/_search");
            request.setEntity((HttpEntity)entity);
            Response response = this.lowClient.performRequest(request);
            logger.debug("[ESSearchApi][search] performRequest[{}]", (Object)(System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
            NamedXContentRegistry registry = new NamedXContentRegistry(Stream.of(this.getDefaultNamedXContents().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)JsonXContent.jsonXContent.createParser(registry, DEPRECATION_HANDLER, response.getEntity().getContent()));
            logger.debug("[ESSearchApi][search] parseContent[{}]", (Object)(System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
            ESApiResponse<T> esApiResponse = this.toResponse(searchResponse);
            logger.debug("[ESSearchApi][search] parseObject[{}]", (Object)(System.currentTimeMillis() - beginTime));
            return esApiResponse;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String parseParameter(ESSearchParameter parameter) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ArrayList esNestedFilterBuilders = Lists.newArrayList();
        block5: for (IESFilterBuilder e2 : parameter.getFilters()) {
            Object queryBuilder = null;
            EESFilterType esFilterType = EESFilterType.MUST;
            if (e2 instanceof ESTermFilterBuilder) {
                ESTermFilterBuilder termFilter = (ESTermFilterBuilder)e2;
                if (termFilter.getValue() == null && termFilter.getValues() == null) continue;
                queryBuilder = termFilter.isMultiValue() ? QueryBuilders.termsQuery((String)termFilter.getFieldName(), (Collection)termFilter.getValues()) : QueryBuilders.termQuery((String)termFilter.getFieldName(), (Object)termFilter.getValue());
                esFilterType = termFilter.getFilterType();
            } else if (e2 instanceof ESRangeFilterBuilder) {
                ESRangeFilterBuilder rangeFilter = (ESRangeFilterBuilder)e2;
                queryBuilder = QueryBuilders.rangeQuery((String)rangeFilter.getFieldName()).from(rangeFilter.getFrom()).to(rangeFilter.getTo()).includeLower(rangeFilter.isIncludeLower()).includeUpper(rangeFilter.isIncludeUpper());
                esFilterType = rangeFilter.getFilterType();
            } else if (e2 instanceof ESNestedFilterBuilder) {
                ESNestedFilterBuilder nestedFilterBuilder = (ESNestedFilterBuilder)e2;
                queryBuilder = QueryBuilders.nestedQuery((String)nestedFilterBuilder.getPath(), (QueryBuilder)nestedFilterBuilder.getBoolQueryBuilder(), (ScoreMode)nestedFilterBuilder.getScoreMode());
                esFilterType = nestedFilterBuilder.getFilterType();
                esNestedFilterBuilders.add(nestedFilterBuilder);
            }
            if (queryBuilder == null) continue;
            switch (esFilterType) {
                case MUST: {
                    boolQueryBuilder.must((QueryBuilder)queryBuilder);
                    continue block5;
                }
                case MUST_NOT: {
                    boolQueryBuilder.mustNot((QueryBuilder)queryBuilder);
                    continue block5;
                }
                case SHOULD: {
                    boolQueryBuilder.should((QueryBuilder)queryBuilder);
                    continue block5;
                }
            }
            boolQueryBuilder.must((QueryBuilder)queryBuilder);
        }
        if (!parameter.isShowAll() && parameter.getShowUntilDate() > 0) {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
            queryBuilder.should((QueryBuilder)QueryBuilders.rangeQuery((String)"releaseDateInt").lt((Object)parameter.getShowUntilDate()));
            queryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"connected", (int)1));
            boolQueryBuilder.must((QueryBuilder)queryBuilder);
        }
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        filterBuilder.filter((QueryBuilder)boolQueryBuilder);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)filterBuilder);
        searchSourceBuilder.explain(Boolean.valueOf(false));
        searchSourceBuilder.from(parameter.getFrom());
        searchSourceBuilder.size(parameter.getSize());
        parameter.getOrders().forEach(e -> {
            SortOrder order;
            SortOrder sortOrder = order = e.isAscending() ? SortOrder.ASC : SortOrder.DESC;
            if (e.getSource().equals("_score")) {
                ScoreSortBuilder scoreSortBuilder = (ScoreSortBuilder)SortBuilders.scoreSort().order(order);
                searchSourceBuilder.sort((SortBuilder)scoreSortBuilder);
            } else {
                FieldSortBuilder fieldSortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)e.getSource()).order(order);
                if (StringUtils.isNotEmpty((CharSequence)e.getNestedPath())) {
                    fieldSortBuilder.setNestedPath(e.getNestedPath());
                    List<ESNestedFilterBuilder> sortESNestedFilterBuilders = esNestedFilterBuilders.stream().filter(nf -> nf.getPath().equals(e.getNestedPath())).collect(Collectors.toList());
                    BoolQueryBuilder sortBoolQueryBuilder = QueryBuilders.boolQuery();
                    sortESNestedFilterBuilders.forEach(snf -> {
                        if (snf.getFilterType() != null) {
                            switch (snf.getFilterType()) {
                                case MUST: {
                                    sortBoolQueryBuilder.must((QueryBuilder)snf.getBoolQueryBuilder());
                                    break;
                                }
                                case MUST_NOT: {
                                    sortBoolQueryBuilder.mustNot((QueryBuilder)snf.getBoolQueryBuilder());
                                    break;
                                }
                                case SHOULD: {
                                    sortBoolQueryBuilder.should((QueryBuilder)snf.getBoolQueryBuilder());
                                    break;
                                }
                                default: {
                                    sortBoolQueryBuilder.must((QueryBuilder)snf.getBoolQueryBuilder());
                                }
                            }
                        }
                    });
                    fieldSortBuilder.setNestedFilter((QueryBuilder)sortBoolQueryBuilder);
                }
                searchSourceBuilder.sort((SortBuilder)fieldSortBuilder);
            }
        });
        return searchSourceBuilder.toString();
    }

    private <T> ESApiResponse<T> toResponse(SearchResponse searchResponse) {
        ESApiResponse response = new ESApiResponse();
        if (searchResponse != null) {
            response.setTookTime(searchResponse.getTook().getMillis());
            response.setHitTotal(searchResponse.getHits().getTotalHits());
            response.setHitCount(searchResponse.getHits().getHits().length);
            long curTS = System.currentTimeMillis();
            for (SearchHit searchHit : searchResponse.getHits().getHits()) {
                Class<T> valueType = this.getValueType(searchHit.getType());
                T v = this.fromJsonStr(searchHit.getSourceAsString(), valueType);
                response.getSource().add(v);
            }
            TimeStatisticsTools.addTime((String)String.format("ES-SEARCH-API:SEARCH:JSON", new Object[0]), (int)searchResponse.getHits().getHits().length, (long)(System.currentTimeMillis() - curTS));
        }
        return response;
    }

    private <T> ESApiResponse<T> toResponse(MultiGetResponse multiGetResponse) {
        ESApiResponse response = new ESApiResponse();
        if (multiGetResponse != null) {
            for (MultiGetItemResponse itemResponse : multiGetResponse.getResponses()) {
                GetResponse getResponse = itemResponse.getResponse();
                if (!getResponse.isExists()) continue;
                Class<T> valueType = this.getValueType(getResponse.getType());
                T v = this.fromJsonStr(getResponse.getSourceAsString(), valueType);
                response.getSource().add(v);
            }
        }
        return response;
    }

    public <T> Class<T> getValueType(String type) {
        switch (type) {
            case "mediaBase": {
                return MediaBase.class;
            }
            case "mediaSummary": {
                return MediaSummary.class;
            }
            case "media_detail": {
                return MediaDetail.class;
            }
            case "media_user_review": {
                return MediaUserReview.class;
            }
            case "media_synopsis": {
                return MediaSynopsis.class;
            }
            case "media_parents_guide": {
                return MediaParentsGuide.class;
            }
            case "media_image": {
                return MediaImage.class;
            }
            case "person": {
                return Person.class;
            }
            case "media_cloud": {
                return MediaCloud.class;
            }
            case "media_award": {
                return MediaAward.class;
            }
            case "media_search_index": {
                return MediaSearchIndex.class;
            }
            case "media_cloud_search_index": {
                return MediaCloudSearchIndex.class;
            }
            case "person_search_index": {
                return PersonSearchIndex.class;
            }
        }
        return null;
    }

    public <T> ESApiResponse<T> getDocumentByIds(String index, String type, Set<String> docIds) {
        MultiGetRequest mgetRequest = new MultiGetRequest();
        docIds.forEach(e -> mgetRequest.add(index, type, e));
        try {
            MultiGetResponse multiGetResponse = this.client.multiGet(mgetRequest, new Header[0]);
            return this.toResponse(multiGetResponse);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private List<NamedXContentRegistry.Entry> getDefaultNamedXContents() {
        HashMap<String, ContextParser> map = new HashMap<String, ContextParser>();
        map.put("cardinality", (p, c) -> ParsedCardinality.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentiles", (p, c) -> ParsedHDRPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentile_ranks", (p, c) -> ParsedHDRPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentiles", (p, c) -> ParsedTDigestPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentile_ranks", (p, c) -> ParsedTDigestPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("percentiles_bucket", (p, c) -> ParsedPercentilesBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("min", (p, c) -> ParsedMin.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("max", (p, c) -> ParsedMax.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sum", (p, c) -> ParsedSum.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("avg", (p, c) -> ParsedAvg.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("value_count", (p, c) -> ParsedValueCount.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("simple_value", (p, c) -> ParsedSimpleValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("derivative", (p, c) -> ParsedDerivative.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("bucket_metric_value", (p, c) -> ParsedBucketMetricValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats", (p, c) -> ParsedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats_bucket", (p, c) -> ParsedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats", (p, c) -> ParsedExtendedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats_bucket", (p, c) -> ParsedExtendedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_bounds", (p, c) -> ParsedGeoBounds.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_centroid", (p, c) -> ParsedGeoCentroid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("histogram", (p, c) -> ParsedHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_histogram", (p, c) -> ParsedDateHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sterms", (p, c) -> ParsedStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("lterms", (p, c) -> ParsedLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("dterms", (p, c) -> ParsedDoubleTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("missing", (p, c) -> ParsedMissing.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("nested", (p, c) -> ParsedNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("reverse_nested", (p, c) -> ParsedReverseNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("global", (p, c) -> ParsedGlobal.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filter", (p, c) -> ParsedFilter.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sampler", (p, c) -> ParsedSampler.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geohash_grid", (p, c) -> ParsedGeoHashGrid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("range", (p, c) -> ParsedRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_range", (p, c) -> ParsedDateRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_distance", (p, c) -> ParsedGeoDistance.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filters", (p, c) -> ParsedFilters.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("adjacency_matrix", (p, c) -> ParsedAdjacencyMatrix.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("siglterms", (p, c) -> ParsedSignificantLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sigsterms", (p, c) -> ParsedSignificantStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("scripted_metric", (p, c) -> ParsedScriptedMetric.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("ip_range", (p, c) -> ParsedBinaryRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("top_hits", (p, c) -> ParsedTopHits.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("composite", (p, c) -> ParsedComposite.fromXContent((XContentParser)p, (String)((String)c)));
        List<NamedXContentRegistry.Entry> entries = map.entrySet().stream().map(entry -> new NamedXContentRegistry.Entry(Aggregation.class, new ParseField((String)entry.getKey(), new String[0]), (ContextParser)entry.getValue())).collect(Collectors.toList());
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("term", new String[0]), (parser, context) -> TermSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("phrase", new String[0]), (parser, context) -> PhraseSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("completion", new String[0]), (parser, context) -> CompletionSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        return entries;
    }

    public static void main(String[] args) {
        ESSearchParameter parameter = ESSearchParameter.builder().index("media_detail").type("media_detail").size(10000).add(ESTermFilterBuilder.builder("seriesId").setValue(19870832));
    }
}

