/*
 * Decompiled with CFR 0.152.
 */
package com.mfc.es.api.client;

import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.Signer;
import com.amazonaws.http.AWSRequestSigningApacheInterceptor;
import com.google.common.collect.Lists;
import com.mfc.es.api.client.ESIndexApi;
import com.mfc.es.api.model.client.ESProperties;
import com.mfc.es.api.model.service.base.IDocument;
import com.mfc.es.api.tools.JacksonUtils;
import common.config.tools.config.ConfigTools3;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESApi {
    private static final Logger logger = LoggerFactory.getLogger(ESIndexApi.class);
    protected RestClient lowClient = null;
    protected RestHighLevelClient client = null;
    protected boolean bInit = false;
    protected ESProperties properties = null;

    public ESApi(ESProperties properties) {
        this.properties = properties;
        this.bInit = this.init();
    }

    public boolean init() {
        if (this.bInit && this.client != null) {
            return this.bInit;
        }
        logger.info("[ES-API]Connect[{}://{}:{}]", new Object[]{this.properties.getHost(), this.properties.getPort(), this.properties.getProtocol()});
        ArrayList hosts = Lists.newArrayList();
        this.properties.getHost().forEach(e -> hosts.add(new HttpHost(e, this.properties.getPort(), this.properties.getProtocol())));
        HttpHost[] hostArray = new HttpHost[this.properties.getHost().size()];
        hostArray = hosts.toArray(hostArray);
        RestClientBuilder restClientBuilder = null;
        if (StringUtils.isNotEmpty((CharSequence)this.properties.getUserName())) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.properties.getUserName(), this.properties.getPassword()));
            if (StringUtils.isNotEmpty((CharSequence)this.properties.getServerName()) && this.properties.getServerName().equalsIgnoreCase("aliyun")) {
                restClientBuilder = RestClient.builder((HttpHost[])hostArray).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                    final /* synthetic */ CredentialsProvider val$credentialsProvider;
                    {
                        this.val$credentialsProvider = credentialsProvider;
                    }

                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                        return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                    }
                });
                this.lowClient = restClientBuilder.build();
                this.client = new RestHighLevelClient(restClientBuilder);
            } else {
                restClientBuilder = RestClient.builder((HttpHost[])hostArray).setMaxRetryTimeoutMillis(300000).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                    final /* synthetic */ CredentialsProvider val$credentialsProvider;
                    {
                        this.val$credentialsProvider = credentialsProvider;
                    }

                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                        return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                    }
                });
                AWS4Signer signer = new AWS4Signer();
                signer.setServiceName(ConfigTools3.getString((String)"mfc.es.cluster.server.AWS4SignerServiceName", (String)"es"));
                signer.setRegionName(ConfigTools3.getString((String)"mfc.es.cluster.server.AWS4SignerRegionName", (String)"cn-northwest-1"));
                BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.properties.getUserName(), this.properties.getPassword());
                AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCreds);
                AWSRequestSigningApacheInterceptor interceptor = new AWSRequestSigningApacheInterceptor("es", (Signer)signer, (AWSCredentialsProvider)awsCredentialsProvider);
                this.lowClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.properties.getHost().get(0), this.properties.getPort(), this.properties.getProtocol())}).setHttpClientConfigCallback(hacb -> hacb.addInterceptorLast(interceptor)).build();
                this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.properties.getHost().get(0), this.properties.getPort(), this.properties.getProtocol())}).setHttpClientConfigCallback(hacb -> hacb.addInterceptorLast(interceptor)));
            }
        } else {
            restClientBuilder = RestClient.builder((HttpHost[])hostArray);
            this.lowClient = restClientBuilder.build();
            this.client = new RestHighLevelClient(restClientBuilder);
        }
        return this.client != null;
    }

    public boolean hasInit() {
        return this.bInit;
    }

    public String toJson(IDocument doc) {
        try {
            return JacksonUtils.toJson(doc);
        }
        catch (Exception e) {
            logger.info("[ES-API]To json failed. doc:[{}] ex:[{}]", (Object)doc, (Object)e);
            return "";
        }
    }

    public <T> T fromJsonStr(String jsonStr, Class<T> clazz) {
        try {
            return JacksonUtils.toObj(jsonStr, clazz);
        }
        catch (Exception e) {
            logger.info("[ES-API]From json failed. doc:[{}] ex:[{}]", (Object)jsonStr, (Object)e);
            return null;
        }
    }
}

