package com.mfc.es.api.model.service.media;

import com.mfc.es.api.model.service.base.IDocument;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

//the index for search request
public class MediaSearchIndex implements IDocument {

    protected Long id = -1L;
    protected String metaId;
    private Double popularity = 0.0;
    private Double rating = 0.0;
    private LinkedHashSet<Long> countries = new LinkedHashSet();
    private Set<Long> genres = new LinkedHashSet();
    private Set<String> companies = new LinkedHashSet();
    private Integer releaseDateInt = 0;
    private Integer year = 0;
    private Set<Long> clouds = new LinkedHashSet();
    private Set<String> cloudsAudioLanguage = new LinkedHashSet();
    private String firstLanguage;
    private Long connectedTime = 0L;
    private Integer lastAirDateInt = 0;
    private Integer linkedLastAirDateInt = 0;
    private List<MediaCertification> certifications = new ArrayList<>();
    private List<MediaTag> tags = new ArrayList<>();//标签
    private Set<String> tagIds = new LinkedHashSet();
    private Integer status = 0;
    private List<MediaPlaylist> playlists = new ArrayList();
    private Integer mediaType = 0;
    private Long seriesId = 0L;
    private Long seasonId = 0L;
    private Integer season = 0;
    private Integer episode = 0;
    private String ppId;
    private Double weightRating = 0.0;
    private Integer mediaSeq = 0;//hot影片排序字段，用于生成随机顺序

    private Long publishLastModifyTime = 0L;
    private String originalTitle = "";
    private Long lastConnectedTime = 0L;
    private Long runtime = 0L;

    private Double recommendValue = 0.0;//hot影片推荐指数字段，用于默认推荐列表
    private Long like = 0L;//hot点赞字段
    private Long viewedAll = 0L;//hot播放统计，所有时长
    private Long viewedDay = 0L;//hot播放统计，自然天
    private Long viewedWeek = 0L;//hot播放统计，自然周
    private Long viewedMonth = 0L;//hot播放统计，自然月
    private Long viewedYear = 0L;//hot播放统计，自然年

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPublishLastModifyTime() {
        return publishLastModifyTime;
    }

    public void setPublishLastModifyTime(Long publishLastModifyTime) {
        this.publishLastModifyTime = publishLastModifyTime;
    }

    public String getOriginalTitle() {
        return originalTitle;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = originalTitle;
    }

    public Long getLastConnectedTime() {
        return lastConnectedTime;
    }

    public void setLastConnectedTime(Long lastConnectedTime) {
        this.lastConnectedTime = lastConnectedTime;
    }

    public String getMetaId() {
        return metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public Double getPopularity() {
        return popularity;
    }

    public void setPopularity(Double popularity) {
        this.popularity = popularity;
    }

    public Double getRating() {
        return rating;
    }

    public void setRating(Double rating) {
        this.rating = rating;
    }

    public LinkedHashSet<Long> getCountries() {
        return countries;
    }

    public void setCountries(LinkedHashSet<Long> countries) {
        this.countries = countries;
    }

    public Set<Long> getGenres() {
        return genres;
    }

    public void setGenres(Set<Long> genres) {
        this.genres = genres;
    }

    public Set<String> getCompanies() {
        return companies;
    }

    public void setCompanies(Set<String> companies) {
        this.companies = companies;
    }

    public Integer getReleaseDateInt() {
        return releaseDateInt;
    }

    public void setReleaseDateInt(Integer releaseDateInt) {
        this.releaseDateInt = releaseDateInt;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Set<Long> getClouds() {
        return clouds;
    }

    public void setClouds(Set<Long> clouds) {
        this.clouds = clouds;
    }

    public Set<String> getCloudsAudioLanguage() {
        return cloudsAudioLanguage;
    }

    public void setCloudsAudioLanguage(Set<String> cloudsAudioLanguage) {
        this.cloudsAudioLanguage = cloudsAudioLanguage;
    }

    public String getFirstLanguage() {
        return firstLanguage;
    }

    public void setFirstLanguage(String firstLanguage) {
        this.firstLanguage = firstLanguage;
    }

    public Long getConnectedTime() {
        return connectedTime;
    }

    public void setConnectedTime(Long connectedTime) {
        this.connectedTime = connectedTime;
    }

    public Integer getLastAirDateInt() {
        return lastAirDateInt;
    }

    public void setLastAirDateInt(Integer lastAirDateInt) {
        this.lastAirDateInt = lastAirDateInt;
    }

    public Integer getLinkedLastAirDateInt() {
        return linkedLastAirDateInt;
    }

    public void setLinkedLastAirDateInt(Integer linkedLastAirDateInt) {
        this.linkedLastAirDateInt = linkedLastAirDateInt;
    }

    public List<MediaCertification> getCertifications() {
        return certifications;
    }

    public void setCertifications(List<MediaCertification> certifications) {
        this.certifications = certifications;
    }

    public List<MediaTag> getTags() {
        return tags;
    }

    public void setTags(List<MediaTag> tags) {
        this.tags = tags;
    }


    @Override
    public String getDocumentId() {
        return id.toString();
    }


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<MediaPlaylist> getPlaylists() {
        return playlists;
    }

    public void setPlaylists(List<MediaPlaylist> playlists) {
        this.playlists = playlists;
    }

    public Integer getMediaType() {
        return mediaType;
    }

    public void setMediaType(Integer mediaType) {
        this.mediaType = mediaType;
    }

    public Long getSeriesId() {
        return seriesId;
    }

    public void setSeriesId(Long seriesId) {
        this.seriesId = seriesId;
    }

    public Long getSeasonId() {
        return seasonId;
    }

    public void setSeasonId(Long seasonId) {
        this.seasonId = seasonId;
    }

    public Integer getEpisode() {
        return episode;
    }

    public void setEpisode(Integer episode) {
        this.episode = episode;
    }

    public Integer getSeason() {
        return season;
    }

    public void setSeason(Integer season) {
        this.season = season;
    }

    public String getPpId() {
        return ppId;
    }

    public void setPpId(String ppId) {
        this.ppId = ppId;
    }

    public Double getWeightRating() {
        return weightRating;
    }

    public void setWeightRating(Double weightRating) {
        this.weightRating = weightRating;
    }

    public Integer getMediaSeq() {
        return mediaSeq;
    }

    public void setMediaSeq(Integer mediaSeq) {
        this.mediaSeq = mediaSeq;
    }


    public Set<String> getTagIds() {
        return tagIds;
    }

    public void setTagIds(Set<String> tagIds) {
        this.tagIds = tagIds;
    }

    public Long getRuntime() {
        return runtime;
    }

    public void setRuntime(Long runtime) {
        this.runtime = runtime;
    }

    public Double getRecommendValue() {
        return recommendValue;
    }

    public void setRecommendValue(Double recommendValue) {
        this.recommendValue = recommendValue;
    }

    public Long getLike() {
        return like;
    }

    public void setLike(Long like) {
        this.like = like;
    }

    public Long getViewedAll() {
        return viewedAll;
    }

    public void setViewedAll(Long viewedAll) {
        this.viewedAll = viewedAll;
    }

    public Long getViewedDay() {
        return viewedDay;
    }

    public void setViewedDay(Long viewedDay) {
        this.viewedDay = viewedDay;
    }

    public Long getViewedWeek() {
        return viewedWeek;
    }

    public void setViewedWeek(Long viewedWeek) {
        this.viewedWeek = viewedWeek;
    }

    public Long getViewedMonth() {
        return viewedMonth;
    }

    public void setViewedMonth(Long viewedMonth) {
        this.viewedMonth = viewedMonth;
    }

    public Long getViewedYear() {
        return viewedYear;
    }

    public void setViewedYear(Long viewedYear) {
        this.viewedYear = viewedYear;
    }
}
