/*
 * Decompiled with CFR 0.152.
 */
package com.mfc.es.api.model.client;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class ESProperties {
    @Deprecated
    public static final String CLUSTER_NAME = "clusterName";
    public static final String HOST = "serverHost";
    public static final String PORT = "serverPort";
    public static final String PROTOCOL = "serverProtocol";
    public static final String USER_NAME = "userName";
    public static final String PASSWORD = "password";
    public static final String SERVERNAME = "serverName";
    public static final String BULK_SIZE = "bulkSize";
    public static final String BULK_BYTE_SIZE = "bulkByteSize";
    public static final String BULK_FLUSH_INTERVAL = "bulkFlushInterval";
    public static final String BULK_CONCURRENT = "bulkConcurrent";
    public static final String BULK_BACKOFF_INITIALDELAY = "bulkBackoffInitialdelay";
    public static final String BULK_BACKOFF_RETRY = "bulkBackoffRetry";
    public static final String LOG_PATH = "logPath";
    Map<String, Object> propertyMap = Maps.newHashMap();

    public static ESProperties builder() {
        return new ESProperties();
    }

    public ESProperties setProperty(String key, Object value) {
        this.propertyMap.put(key, value);
        return this;
    }

    public ESProperties clusterName(String clusterName) {
        return this.setProperty(CLUSTER_NAME, clusterName);
    }

    public ESProperties host(List<String> serverHost) {
        return this.setProperty(HOST, serverHost);
    }

    public ESProperties host(String serverHost) {
        List serverHostList = (List)this.propertyMap.get(HOST);
        if (serverHost != null) {
            serverHostList.add(serverHost);
        } else {
            this.propertyMap.put(HOST, ImmutableList.of((Object)serverHost));
        }
        return this;
    }

    public ESProperties port(int serverPort) {
        return this.setProperty(PORT, serverPort);
    }

    public ESProperties protocol(String protocol) {
        return this.setProperty(PROTOCOL, protocol);
    }

    public ESProperties userName(String userName) {
        return this.setProperty(USER_NAME, userName);
    }

    public ESProperties password(String password) {
        return this.setProperty(PASSWORD, password);
    }

    public ESProperties serverName(String serverName) {
        return this.setProperty(SERVERNAME, serverName);
    }

    public ESProperties bulkSize(int bulkSize) {
        return this.setProperty(BULK_SIZE, bulkSize);
    }

    public ESProperties bulkByteSize(int bulkByteSize) {
        return this.setProperty(BULK_BYTE_SIZE, bulkByteSize);
    }

    public ESProperties bulkFlushInterval(int bulkFlushInterval) {
        return this.setProperty(BULK_FLUSH_INTERVAL, bulkFlushInterval);
    }

    public ESProperties bulkConcurrent(int bulkConcurrent) {
        return this.setProperty(BULK_CONCURRENT, bulkConcurrent);
    }

    public ESProperties bulkBackoffInitialdelay(int bulkBackoffInitialdelay) {
        return this.setProperty(BULK_BACKOFF_INITIALDELAY, bulkBackoffInitialdelay);
    }

    public ESProperties bulkBackoffRetry(int bulkBackoffRetry) {
        return this.setProperty(BULK_BACKOFF_RETRY, bulkBackoffRetry);
    }

    public Object getProperty(String key) {
        return this.propertyMap.get(key);
    }

    public String getClusterName() {
        return (String)this.propertyMap.getOrDefault(CLUSTER_NAME, "");
    }

    public List<String> getHost() {
        return (List)this.getProperty(HOST);
    }

    public int getPort() {
        return (Integer)this.propertyMap.get(PORT);
    }

    public String getProtocol() {
        return (String)this.propertyMap.getOrDefault(PROTOCOL, "");
    }

    public String getUserName() {
        return (String)this.propertyMap.getOrDefault(USER_NAME, "");
    }

    public String getPassword() {
        return (String)this.propertyMap.getOrDefault(PASSWORD, "");
    }

    public String getServerName() {
        return (String)this.propertyMap.getOrDefault(SERVERNAME, "");
    }

    public int bulkSize() {
        return (Integer)this.propertyMap.getOrDefault(BULK_SIZE, 500);
    }

    public int bulkByteSize() {
        return (Integer)this.propertyMap.getOrDefault(BULK_BYTE_SIZE, 10);
    }

    public int bulkFlushInterval() {
        return (Integer)this.propertyMap.getOrDefault(BULK_FLUSH_INTERVAL, 10);
    }

    public int bulkConcurrent() {
        return (Integer)this.propertyMap.getOrDefault(BULK_CONCURRENT, 10);
    }

    public int bulkBackoffInitialdelay() {
        return (Integer)this.propertyMap.getOrDefault(BULK_BACKOFF_INITIALDELAY, 100);
    }

    public int bulkBackoffRetry() {
        return (Integer)this.propertyMap.getOrDefault(BULK_BACKOFF_RETRY, 3);
    }

    public String getLogPath() {
        return (String)this.propertyMap.getOrDefault(LOG_PATH, "logs");
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("propertyMap", this.propertyMap).toString();
    }
}

