/*
 * Decompiled with CFR 0.152.
 */
package com.mfc.es.api.model.service.search;

import com.google.common.collect.Sets;
import com.mfc.es.api.model.service.base.AbstractPrintable;
import com.mfc.es.api.model.service.search.ESOrder;
import com.mfc.es.api.model.service.search.IESFilterBuilder;
import common.config.tools.config.ConfigTools3;
import java.util.Set;

public class ESSearchParameter
extends AbstractPrintable {
    private String index;
    private String type;
    private int from;
    private int size;
    private Set<IESFilterBuilder> filters = Sets.newLinkedHashSet();
    private Set<ESOrder> orders = Sets.newLinkedHashSet();
    private boolean showAll = false;
    private int showUntilDate = 0;
    private boolean unLimitSize = false;

    public static ESSearchParameter builder() {
        return new ESSearchParameter();
    }

    public ESSearchParameter index(String index) {
        this.index = index;
        return this;
    }

    public ESSearchParameter type(String type) {
        this.type = type;
        return this;
    }

    public ESSearchParameter from(int from) {
        this.from = from;
        return this;
    }

    public ESSearchParameter size(int size) {
        this.size = size;
        return this;
    }

    public ESSearchParameter add(IESFilterBuilder filter) {
        this.filters.add(filter);
        return this;
    }

    public ESSearchParameter add(ESOrder order) {
        this.orders.add(order);
        return this;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public int getFrom() {
        if (this.unLimitSize) {
            return this.from;
        }
        int max = ConfigTools3.getInt((String)"es.max.result", (Integer)10000);
        return Math.min(max, this.from);
    }

    public int getSize() {
        if (this.unLimitSize) {
            return this.size;
        }
        int max = ConfigTools3.getInt((String)"es.max.result", (Integer)10000);
        return Math.min(max, this.size);
    }

    public Set<IESFilterBuilder> getFilters() {
        return this.filters;
    }

    public Set<ESOrder> getOrders() {
        return this.orders;
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public int getShowUntilDate() {
        return this.showUntilDate;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setFilters(Set<IESFilterBuilder> filters) {
        this.filters = filters;
    }

    public void setOrders(Set<ESOrder> orders) {
        this.orders = orders;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    public void setShowUntilDate(int showUntilDate) {
        this.showUntilDate = showUntilDate;
    }

    public void setUnLimitSize(boolean unLimitSize) {
        this.unLimitSize = unLimitSize;
    }
}

