/*
 * Decompiled with CFR 0.152.
 */
package com.mfc.es.api.client;

import com.mfc.es.api.client.ESApi;
import com.mfc.es.api.client.ESBulkProcessorListener;
import com.mfc.es.api.model.client.ESProperties;
import com.mfc.es.api.model.service.base.IDocument;
import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESIndexApi
extends ESApi {
    private static final Logger logger = LoggerFactory.getLogger(ESIndexApi.class);
    protected BulkProcessor bulkProcessor = null;

    public ESIndexApi(ESProperties esProperties) {
        super(esProperties);
        this.initBulkProcessor();
    }

    public IndexResponse updateIndex(String index, String type, IDocument doc) {
        if (!this.hasInit()) {
            return null;
        }
        String json = this.toJson(doc);
        if (!Strings.isNullOrEmpty((String)json)) {
            IndexRequest indexRequest = new IndexRequest(index, type, doc.getDocumentId());
            indexRequest.source(json, XContentType.JSON);
            try {
                return this.client.index(indexRequest, new Header[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public BulkResponse bulkUpdateIndex(String index, String type, List<IDocument> docList) {
        BulkRequest bulkRequest = new BulkRequest();
        for (IDocument doc : docList) {
            String json = this.toJson(doc);
            if (Strings.isNullOrEmpty((String)json)) continue;
            try {
                bulkRequest.add(new IndexRequest(index, type, doc.getDocumentId()).source(json, XContentType.JSON));
            }
            catch (Exception e) {
                logger.error("bulkUpdateIndex bulkRequest error");
                return null;
            }
        }
        if (bulkRequest.numberOfActions() > 0) {
            try {
                return this.client.bulk(bulkRequest, new Header[0]);
            }
            catch (IOException e) {
                logger.error("[bulkUpdateIndex][ERROR],ex:[{}]", (Throwable)e);
                return null;
            }
        }
        logger.error("[bulkUpdateIndex] numberOfActions<=0");
        return null;
    }

    public void initBulkProcessor() {
        this.bulkProcessor = BulkProcessor.builder((x$0, x$1) -> this.client.bulkAsync(x$0, x$1, new Header[0]), (BulkProcessor.Listener)new ESBulkProcessorListener()).setBulkActions(this.properties.bulkSize()).setBulkSize(new ByteSizeValue((long)this.properties.bulkByteSize(), ByteSizeUnit.MB)).setFlushInterval(TimeValue.timeValueSeconds((long)this.properties.bulkFlushInterval())).setConcurrentRequests(this.properties.bulkConcurrent()).setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)this.properties.bulkBackoffInitialdelay()), (int)this.properties.bulkBackoffRetry())).build();
    }

    public void closeBulkProcessor() {
        this.bulkProcessor.close();
    }

    public void bulkProcessorUpsert(String index, String type, IDocument document) {
        if (document == null) {
            return;
        }
        String json = this.toJson(document);
        if (!Strings.isNullOrEmpty((String)json)) {
            this.bulkProcessor.add(new IndexRequest(index, type, document.getDocumentId()).source(json, XContentType.JSON));
        }
    }

    public void bulkProcessorRemove(String index, String type, String id) {
        this.bulkProcessor.add(new DeleteRequest(index, type, id));
    }
}

