/*
 * Decompiled with CFR 0.152.
 */
package com.mfc.es.api.client;

import com.google.common.base.Joiner;
import com.mfc.es.api.client.ESIndexApi;
import common.base.tools.stat.MetricTools;
import common.base.tools.stat.StatTools;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESBulkProcessorListener
implements BulkProcessor.Listener {
    private static final Logger logger = LoggerFactory.getLogger(ESIndexApi.class);

    public void beforeBulk(long executionId, BulkRequest request) {
        logger.info("[ES-API][BULK-BEFORE]executionId[{}] request[number:({}) size:({})]", new Object[]{executionId, request.numberOfActions(), request.estimatedSizeInBytes()});
        for (DocWriteRequest req : request.requests()) {
            if (!(req instanceof DocWriteRequest)) continue;
            DocWriteRequest dr = req;
            StatTools.addReq((String)Joiner.on((String)"_").join((Object)"es", (Object)dr.index(), new Object[]{dr.type()}));
        }
    }

    public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
        if (!response.hasFailures()) {
            logger.info("[ES-API][BULK-AFTER]executionId[{}] request[number:({}) size:({})] response[Took:[{}] IngestTook:[{}]]", new Object[]{executionId, request.numberOfActions(), request.estimatedSizeInBytes(), response.getTook().getMillis(), response.getIngestTookInMillis()});
        } else {
            logger.error("[ES-API][BULK-AFTER]executionId[{}] request[number:({}) size:({})] response[Took:[{}] IngestTook:[{}]] Failure msg:{}", new Object[]{executionId, request.numberOfActions(), request.estimatedSizeInBytes(), response.getTook().getMillis(), response.getIngestTookInMillis(), response.buildFailureMessage()});
        }
        MetricTools.logESTime((String)"bulk", (String)"bulk", (int)request.numberOfActions(), (long)response.getTook().getMillis());
        for (BulkItemResponse bis : response.getItems()) {
            if (bis.isFailed()) {
                StatTools.addErr((String)Joiner.on((String)"_").join((Object)"es", (Object)bis.getIndex(), new Object[]{bis.getType()}));
                continue;
            }
            StatTools.addRsp((String)Joiner.on((String)"_").join((Object)"es", (Object)bis.getIndex(), new Object[]{bis.getType()}));
        }
    }

    public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
        logger.error(String.format("[ES-API][BULK-AFTER][EXCEPTION]executionId[%s] request[number:(%s) size:(%s)]", executionId, request.numberOfActions(), request.estimatedSizeInBytes()), failure);
        for (DocWriteRequest req : request.requests()) {
            if (!(req instanceof DocWriteRequest)) continue;
            DocWriteRequest dr = req;
            StatTools.addErr((String)Joiner.on((String)"_").join((Object)"es", (Object)dr.index(), new Object[]{dr.type()}));
        }
    }
}

