package com.mfc.es.api.client;


import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.http.AWSRequestSigningApacheInterceptor;
import com.google.common.collect.Lists;
import com.mfc.es.api.model.client.ESProperties;
import com.mfc.es.api.model.service.base.IDocument;
import com.mfc.es.api.tools.JacksonUtils;
import common.config.tools.config.ConfigTools3;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * Created by Frank.Huang on 2017/3/16.
 */
public class ESApi {

    private static final Logger logger = LoggerFactory.getLogger(ESIndexApi.class);
    protected RestClient lowClient = null;
    protected RestHighLevelClient client = null;
    protected boolean bInit = false;

//    private static final Gson gson = new Gson();

    protected ESProperties properties = null;
//    protected String host = ConfigTools3.getString("mfc.es.service.host");
//    protected int port = ConfigTools3.getInt("mfc.es.service.port");
//    protected String protocol = ConfigTools3.getString("mfc.es.service.protocol");
//
//    protected int bulkActions = ConfigTools3.getInt("mfc.es.bulk.actions", 500);
//    protected int bulkSize = ConfigTools3.getInt("mfc.es.bulk.size", 10);
//    protected int bulkFlushInterval = ConfigTools3.getInt("mfc.es.bulk.flush.interval", 10);
//    protected int bulkConcurrent = ConfigTools3.getInt("mfc.es.bulk.flush.interval", 10);
//    protected int bulkBackoffInitialDelay = ConfigTools3.getInt("mfc.es.bulk.flush.interval", 100);
//    protected int bulkBackoffRetry = ConfigTools3.getInt("mfc.es.bulk.backoff.retry.max", 3);


    public ESApi(ESProperties properties) {
        this.properties = properties;

        this.bInit = init();

    }

    public boolean init() {
        if (bInit && client != null) {
            return bInit;
        }

        logger.info("[ES-API]Connect[{}://{}:{}]", properties.getHost(), properties.getPort(), properties.getProtocol());
        List<HttpHost> hosts = Lists.newArrayList();
        properties.getHost().forEach(e -> {
            hosts.add(new HttpHost(e, properties.getPort(), properties.getProtocol()));
        });

        HttpHost[] hostArray = new HttpHost[properties.getHost().size()];
        hostArray = hosts.toArray(hostArray);

        RestClientBuilder restClientBuilder = null;

        if (StringUtils.isNotEmpty(properties.getUserName())){
            final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(properties.getUserName(), properties.getPassword()));

            if (StringUtils.isNotEmpty(properties.getServerName()) && properties.getServerName().equalsIgnoreCase("aliyun")) {
                restClientBuilder = RestClient.builder(hostArray).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback() {
                    @Override
                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                    }
                });
                lowClient = restClientBuilder.build();
                client = new RestHighLevelClient(restClientBuilder);
            }else {
                restClientBuilder = RestClient.builder(hostArray).setMaxRetryTimeoutMillis(5 * 60 * 1000)
                        .setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback() {
                            @Override
                            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                                return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                            }
                        });
                AWS4Signer signer = new AWS4Signer();
                signer.setServiceName(ConfigTools3.getString("mfc.es.cluster.server.AWS4SignerServiceName", "es"));
                signer.setRegionName(ConfigTools3.getString("mfc.es.cluster.server.AWS4SignerRegionName", "cn-northwest-1"));
                BasicAWSCredentials awsCreds = new BasicAWSCredentials(properties.getUserName(), properties.getPassword());
                final AWSCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider(awsCreds);
                HttpRequestInterceptor interceptor = new AWSRequestSigningApacheInterceptor("es", signer, awsCredentialsProvider);
                lowClient = RestClient.builder(new HttpHost(properties.getHost().get(0), properties.getPort(), properties.getProtocol())).setHttpClientConfigCallback(hacb -> hacb.addInterceptorLast(interceptor)).build();
                client = new RestHighLevelClient(RestClient.builder(new HttpHost(properties.getHost().get(0), properties.getPort(), properties.getProtocol())).setHttpClientConfigCallback(hacb -> hacb.addInterceptorLast(interceptor)));

            }
        }else {
            restClientBuilder = RestClient.builder(hostArray);
            lowClient = restClientBuilder.build();
            client = new RestHighLevelClient(restClientBuilder);
        }
        if (client != null) {
            return true;
        }
        return false;
    }

    public boolean hasInit() {
        return bInit;
    }

    public String toJson(IDocument doc) {
        try {
            return JacksonUtils.toJson(doc);
        } catch ( Exception e) {
            logger.info("[ES-API]To json failed. doc:[{}] ex:[{}]", doc, e);
            return "";
        }
    }

    public <T> T fromJsonStr(String jsonStr, Class<T> clazz) {
        try {
            return JacksonUtils.toObj(jsonStr, clazz);
        } catch (Exception e) {
            logger.info("[ES-API]From json failed. doc:[{}] ex:[{}]", jsonStr, e);
            return null;
        }
    }
}
