package com.mfc.es.api.model.service.media;

import com.google.common.hash.Hashing;
import com.mfc.es.api.model.service.base.AbstractLocaleDoc;
import org.elasticsearch.common.Strings;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.Objects;

/**
 * Created by Frank.Huang on 2017/3/3.
 */
public class MediaImage extends AbstractLocaleDoc {
    private String source;
    private String sourceId;
    private String artworkType;
    private Integer height;
    private Integer width;
    private Integer adult;
    private Date createTime;
    private Integer imageType;
    private Integer master;
    private String url;
    private Integer showSeq;

    public Integer getImageType() {
        return imageType;
    }

    public void setImageType(Integer imageType) {
        this.imageType = imageType;
    }

    public Integer getMaster() {
        return master;
    }

    public void setMaster(Integer master) {
        this.master = master;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getArtworkType() {
        return artworkType;
    }

    public void setArtworkType(String artworkType) {
        this.artworkType = artworkType;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getAdult() {
        return adult;
    }

    public void setAdult(Integer adult) {
        this.adult = adult;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getShowSeq() {
        return showSeq;
    }

    public void setShowSeq(Integer showSeq) {
        this.showSeq = showSeq;
    }

    @Override
    public String getDocumentId() {
        if (!Strings.isNullOrEmpty(documentId)) {
            return documentId;
        }

        return makeDocumentId(id,language,master,showSeq, Hashing.md5().hashString(url, Charset.forName("utf-8")));
    }

//    public boolean valueEquals(Object o) {
//        if (o == null || getClass() != o.getClass()) return false;
//        MediaImage that = (MediaImage) o;
//        return Objects.equals(source, that.source) &&
//                Objects.equals(sourceId, that.sourceId) &&
//                Objects.equals(artworkType, that.artworkType) &&
//                Objects.equals(height, that.height) &&
//                Objects.equals(width, that.width) &&
//                Objects.equals(adult, that.adult) &&
//                Objects.equals(imageType, that.imageType) &&
//                Objects.equals(master, that.master) &&
//                Objects.equals(url, that.url) &&
//                Objects.equals(showSeq, that.showSeq);
//    }

}
