package com.valor.mfc.vms.common.cache;

import com.google.common.base.Strings;

import com.valor.mfc.vms.api.common.encrypt.Base64Utils;
import common.base.tools.sys.SystemTools;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.RMICacheManagerPeerListenerFactory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by Frank.Huang on 2016/10/26.
 */
public class EHCacheRMIPeerListenerFactory extends RMICacheManagerPeerListenerFactory {
    private static final Logger logger = LoggerFactory.getLogger(EHCacheRMIPeerListenerFactory.class);
    public static final String  ENV_EHCACHE_LOCAL="mfc_cache_local_eth";

    public EHCacheRMIPeerListenerFactory() {
    }

    @Override
    protected CacheManagerPeerListener doCreateCachePeerListener(String hostName, Integer port, Integer remoteObjectPort, CacheManager cacheManager, Integer socketTimeoutMillis) {
        String newHostName = hostName;
        String networkInterfaceName = Base64Utils.decode(SystemTools.getenv(ENV_EHCACHE_LOCAL));
        if (!Strings.isNullOrEmpty(networkInterfaceName)){
            String ipAddr = SystemTools.getIpAddress(true,networkInterfaceName);
            if (!Strings.isNullOrEmpty(ipAddr)){
                newHostName = ipAddr;
                logger.info("Use Hostname[{}] replace[{}]",newHostName,hostName);
            }
        }

        return super.doCreateCachePeerListener(newHostName, port, remoteObjectPort, cacheManager, socketTimeoutMillis);
    }
}
