package com.valor.mfc.vms.common.service;

import com.valor.mfc.vms.common.tools.sys.ThreadRunTool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;

/**
 * Created by Frank.Huang on 2016/5/5.
 */
public class ChangedScanRunner2 {
    private static final Logger logger = LoggerFactory.getLogger(ChangedScanRunner2.class);

    private IChangedScanner scanner;
    private IChangedProcessorFactory  processorFactory;
    private String scannerName ="";


    public ChangedScanRunner2(String scannerName, IChangedScanner scanner, IChangedProcessorFactory processorFactory) {
        this.scanner = scanner;
        this.processorFactory = processorFactory;
        this.scannerName = scannerName;
    }

    public void run(int maxResult,int maxThreads,int waitMS){
        run(maxResult,maxThreads,waitMS,true);
    }

    public void run(int maxResult, int maxThreads, int waitMS, boolean printIfNoData){
        BlockingQueue queue = scanner.getChanged(maxResult);

        if (Objects.nonNull(queue) && queue.size() > 0){
            logger.info("[{}] is running with records[{}-{}].",scannerName,maxResult, queue.size());
            ThreadRunTool.runThreads(maxThreads,waitMS,new ChangedRunner2(queue, processorFactory));
        }else {
            if (printIfNoData){
                logger.info("[{}] no records need process.",scannerName);
            }

        }
    }


}
