package com.valor.mfc.vms.common.tools.http;

import com.google.common.base.Strings;


import common.base.tools.sys.SystemTools;
import common.base.tools.type.NumberTools;
import com.valor.mfc.vms.api.model.common.response.ResponseSign;
import com.valor.mfc.vms.api.model.common.response.ResponseStatus;

import org.joda.time.DateTime;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by Frank.Huang on 2016/6/15.
 */
public class HttpTools {

    public static String getRemoteHost(HttpServletRequest request) {
        String remoteHost = null;
        //ipAddress = this.getRequest().getRemoteAddr();
        remoteHost = request.getHeader("x-forwarded-for");
        if (remoteHost == null || remoteHost.length() == 0 || "unknown".equalsIgnoreCase(remoteHost)) {
            remoteHost = request.getHeader("CF-Connecting-IP");
        }
        if (remoteHost == null || remoteHost.length() == 0 || "unknown".equalsIgnoreCase(remoteHost)) {
            remoteHost = request.getHeader("Proxy-Client-IP");
        }
        if (remoteHost == null || remoteHost.length() == 0 || "unknown".equalsIgnoreCase(remoteHost)) {
            remoteHost = request.getHeader("WL-Proxy-Client-IP");
        }
        if (remoteHost == null || remoteHost.length() == 0 || "unknown".equalsIgnoreCase(remoteHost)) {
            remoteHost = request.getRemoteAddr();
        }

        //对于通过多个代理的情况，第一个IP为客户端真实IP,多个IP按照','分割
        if (remoteHost != null && remoteHost.length() > 15) { //"***.***.***.***".length() = 15
            if (remoteHost.indexOf(",") > 0) {
                remoteHost = remoteHost.substring(0, remoteHost.indexOf(","));
            }
        }

        if (Strings.isNullOrEmpty(remoteHost)) {
            remoteHost = "unknown host";
        }

        return remoteHost;
    }

    public static String getHttpParameter(HttpServletRequest request, String key) {
        if (request == null) {
            return "";
        }

        if (Strings.isNullOrEmpty(key)) {
            return "";
        }

        return request.getParameter(key);
    }

    public static Long getLongParameter(HttpServletRequest request, String key) {
        String v = getHttpParameter(request, key);
        if (Strings.isNullOrEmpty(v)) {
            return null;
        }

        return Long.valueOf(v);
    }

    public static Long getLongAttr(HttpServletRequest request, String key) {
        return getLongAttr(request, key, null);
    }

    public static Long getLongAttr(HttpServletRequest request, String key, Long defaultValue) {
        Object v = request.getAttribute(key);
        if (v == null) {
            return defaultValue;
        }

        if (v instanceof Long) {
            return (Long) v;
        } else if (v instanceof String) {
            if (Strings.isNullOrEmpty((String) v)) {
                return defaultValue;
            }

            return Long.valueOf((String) v);
        } else {
            return defaultValue;
        }
    }

    public static int getIntAttr(HttpServletRequest request, String key, int defaultValue) {
        Object v = request.getAttribute(key);
        if (v == null) {
            return defaultValue;
        }

        if (v instanceof Integer) {
            return (int) v;
        }

        if (v instanceof String) {
            return NumberTools.str2int((String) v);
        }

        return defaultValue;
    }


    public static String getAttr(HttpServletRequest request, String key, String defaultValue) {
        Object v = request.getAttribute(key);
        if (v == null) {
            return defaultValue;
        }

        return (String) v;
    }

    public static void setAttrIfAbsent(HttpServletRequest request, String key, Object value) {
        Object v = request.getAttribute(key);
        if (v == null) {
            request.setAttribute(key, value);
        }
    }

    public static void setAttr(HttpServletRequest request, String key, Object value) {
        request.setAttribute(key, value);
    }

    public static void setApiErrorParameter(HttpServletRequest request, int retCode, int errCode, String retMsg, String refer) {
        setAttr(request, HttpConstant.HTTP_REQ_ATTR_RET_CODE, retCode);
        setAttr(request, HttpConstant.HTTP_REQ_ATTR_ERR_CODE, errCode);
        setAttr(request, HttpConstant.HTTP_REQ_ATTR_RET_MSG, retMsg);
        setAttr(request, HttpConstant.HTTP_REQ_ATTR_REFER, refer);
    }

    public static String getApiPath(HttpServletRequest request) {
        return request.getRequestURI();
    }


    public static ResponseStatus updateSrvInfo(HttpServletRequest request, Object retVal) {
        if (retVal instanceof ResponseSign) {
            String token = HttpTools.getAttr(request, HttpConstant.HTTP_REQ_ATTR_TOKEN, "");

            if (!Strings.isNullOrEmpty(token)) {

                String sign = SignTools.sign(token, AppKeyConfig.getAppkey());
                ((ResponseSign) retVal).setServerSign(sign);
            }
        }

        if (retVal instanceof ResponseStatus) {
            ((ResponseStatus) retVal).setServerTimeMS(DateTime.now().getMillis());
            ((ResponseStatus) retVal).setHost(SystemTools.getHostnameMD5());
            return (ResponseStatus) retVal;
        } else {
            return null;
        }
    }

    public static String getRequestURI(HttpServletRequest request) {
        String apiName = request.getRequestURI();
        apiName = apiName.substring(1).replace("/", "_");
        return apiName;
    }

    public static String getClientRegion(HttpServletRequest request) {
        return Strings.nullToEmpty(request.getHeader("CF-IPCountry"));
    }
}
