/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.database.tool.access;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;

public final class SqlScalars {
    private StringBuilder sql;
    private Map<String, BasicType> scalars;
    private final Map<String, Object> parameters;
    private SQLQuery query = null;

    public SqlScalars() {
        this.sql = new StringBuilder();
        this.scalars = new HashMap<String, BasicType>();
        this.parameters = new HashMap<String, Object>();
    }

    public SqlScalars(StringBuilder sql) {
        this.sql = sql;
        this.scalars = new HashMap<String, BasicType>();
        this.parameters = new HashMap<String, Object>();
    }

    public SqlScalars(String sql) {
        this.setSql(sql);
        this.scalars = new HashMap<String, BasicType>();
        this.parameters = new HashMap<String, Object>();
    }

    public SqlScalars(StringBuilder sql, Map<String, BasicType> scalars) {
        this.sql = sql;
        this.scalars = scalars;
        this.parameters = new HashMap<String, Object>();
    }

    public void setSql(StringBuilder sql) {
        this.sql = sql;
    }

    public void setSql(String sql) {
        this.sql = new StringBuilder(sql);
    }

    public void addToSql(String line) {
        this.sql.append(line);
        if (!line.endsWith(" ")) {
            this.sql.append(" ");
        }
    }

    public String getSql() {
        return StringUtils.normalizeSpace((String)this.sql.toString());
    }

    public SQLQuery createSqlQuery(Session session) {
        if (this.query == null) {
            this.query = session.createSQLQuery(this.getSql());
            if (this.parameters != null) {
                for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                    if (entry.getValue() instanceof Collection) {
                        this.query.setParameterList(entry.getKey(), (Collection)entry.getValue());
                        continue;
                    }
                    if (entry.getValue() instanceof Object[]) {
                        this.query.setParameterList(entry.getKey(), (Object[])entry.getValue());
                        continue;
                    }
                    this.query.setParameter(entry.getKey(), entry.getValue());
                }
            }
        }
        return this.query;
    }

    public void addParameter(String param, Object value) {
        this.parameters.put(param, value);
    }

    public void addParameterLike(String param, Object value) {
        this.parameters.put(param, "%" + value + "%");
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void clear() {
        this.sql = new StringBuilder();
        this.parameters.clear();
        this.scalars.clear();
    }

    public Map<String, BasicType> getScalars() {
        return this.scalars;
    }

    public void setScalars(Map<String, BasicType> scalars) {
        this.scalars = scalars;
    }

    public void addScalar(String scalar) {
        this.scalars.put(scalar, null);
    }

    public void addScalar(String scalar, BasicType type) {
        this.scalars.put(scalar, type);
    }

    public void populateScalars(SQLQuery query) {
        if (this.scalars != null && !this.scalars.isEmpty()) {
            for (Map.Entry<String, BasicType> entry : this.scalars.entrySet()) {
                if (entry.getValue() == null) {
                    query.addScalar(entry.getKey());
                    continue;
                }
                query.addScalar(entry.getKey(), (Type)entry.getValue());
            }
        }
    }
}

