/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.database.tool.configruation;

import com.valor.mfc.vms.common.database.tool.configruation.AbstractDBCfg;
import com.zaxxer.hikari.HikariDataSource;
import common.config.tools.config.ConfigTools3;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDBCfgWithHikariCP
extends AbstractDBCfg {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDBCfgWithHikariCP.class);

    @Override
    public DataSource getDataSource(String dbURL, String username, String password) {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(dbURL);
        ds.setUsername(username);
        ds.setPassword(password);
        ds.setMaximumPoolSize(ConfigTools3.getInt((String)"db.HikariCP.maxActive", (Integer)10).intValue());
        ds.setMinimumIdle(ConfigTools3.getInt((String)"db.HikariCP.minIdle", (Integer)10).intValue());
        ds.addDataSourceProperty("cachePrepStmts", (Object)ConfigTools3.getBoolean((String)"db.HikariCP.cachePrepStmts", (boolean)true));
        ds.addDataSourceProperty("prepStmtCacheSize", (Object)ConfigTools3.getInt((String)"db.HikariCP.prepStmtCacheSize", (Integer)250));
        ds.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)ConfigTools3.getInt((String)"db.HikariCP.prepStmtCacheSqlLimit", (Integer)2048));
        ds.addDataSourceProperty("useServerPrepStmts", (Object)ConfigTools3.getBoolean((String)"db.HikariCP.useServerPrepStmts", (boolean)true));
        ds.addDataSourceProperty("useLocalSessionState", (Object)ConfigTools3.getBoolean((String)"db.HikariCP.useLocalSessionState", (boolean)true));
        ds.addDataSourceProperty("rewriteBatchedStatements", (Object)ConfigTools3.getBoolean((String)"db.HikariCP.rewriteBatchedStatements", (boolean)true));
        ds.addDataSourceProperty("cacheResultSetMetadata", (Object)ConfigTools3.getBoolean((String)"db.HikariCP.cacheResultSetMetadata", (boolean)true));
        ds.addDataSourceProperty("cacheResultSetMetadata", (Object)ConfigTools3.getBoolean((String)"db.HikariCP.cacheResultSetMetadata", (boolean)true));
        ds.addDataSourceProperty("elideSetAutoCommits", (Object)ConfigTools3.getBoolean((String)"db.HikariCP.elideSetAutoCommits", (boolean)true));
        ds.addDataSourceProperty("maintainTimeStats", (Object)ConfigTools3.getBoolean((String)"db.HikariCP.elideSetAutoCommits", (boolean)true));
        logger.info(String.format("[HikariCP]Max:%s Min:%s Properties:%s", ds.getMaximumPoolSize(), ds.getMinimumIdle(), ds.getDataSourceProperties().toString()));
        return ds;
    }
}

