/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.tools.http;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.valor.mfc.vms.common.tools.http.HttpTools;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpParameterTools {
    private static final Logger logger = LoggerFactory.getLogger(HttpParameterTools.class);

    public static Map<String, String> getCookies(HttpServletRequest request) {
        HashMap cookieMap = Maps.newHashMap();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie.getValue());
            }
        }
        return cookieMap;
    }

    public static String getCookie(HttpServletRequest request, String cookieKey) {
        HashMap cookieMap = Maps.newHashMap();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName().compareTo(cookieKey) != 0) continue;
                return cookie.getValue();
            }
        }
        return "";
    }

    public static Long getLongParameter(HttpServletRequest request, String key) {
        String value = HttpParameterTools.getCookie(request, key);
        if (Strings.isNullOrEmpty((String)value)) {
            value = HttpTools.getHttpParameter(request, key);
        }
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return Long.valueOf(value);
    }

    public static String getParameter(HttpServletRequest request, String key) {
        String value = HttpParameterTools.getCookie(request, key);
        if (Strings.isNullOrEmpty((String)value)) {
            value = HttpTools.getHttpParameter(request, key);
        }
        return value;
    }
}

