/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.web.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.valor.mfc.vms.common.web.request.BaseRequestArgs;
import com.valor.mfc.vms.common.web.request.IPagingArgs;

public class PagingArgs
extends BaseRequestArgs
implements IPagingArgs {
    private static int MAX_PAGE_SIZE = 300;
    private int pageId = 1;
    private int pageSize = 10;
    private String sort = "";
    private String filter = "";

    @Override
    public int getPageId() {
        return this.pageId;
    }

    @Override
    public void setPageId(int pageId) {
        this.pageId = pageId <= 1 ? 1 : pageId;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        if (pageSize > MAX_PAGE_SIZE) {
            this.argsValid = false;
            this.setVerifyMsg("PageSize", "Page size large than MAX(" + MAX_PAGE_SIZE + ").");
        } else {
            this.pageSize = pageSize > 0 ? pageSize : 10;
        }
    }

    @Override
    public String getSort() {
        return this.sort;
    }

    @Override
    public void setSort(String sort) {
        this.sort = sort;
    }

    @Override
    @JsonIgnore
    public int getPageStart() {
        return (this.pageId - 1) * this.pageSize;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }
}

