package com.valor.mfc.vms.common.database.model;

import com.google.common.base.Strings;
import com.valor.mfc.vms.api.model.common.AbstractPrintable;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * File        : AbstractLMI.java
 * Description : data table Last Modify information(LMI)
 * Author      : Frank
 * Created     : 2015/9/15
 */

@MappedSuperclass
public abstract class AbstractLMI extends AbstractPrintable implements IComparable, Serializable {
    @Column(name = "create_time", updatable = false)
    @Temporal(TemporalType.TIMESTAMP)
    protected Date createTime = new Date();

    @Column(name = "last_modify_user", columnDefinition = "varchar(64) default ''")
    protected String lastModifyUser = "";

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "last_modify_time", columnDefinition = "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP")
    protected Date lastModifyTime = new Date();

    @Column(name = "data_ver", columnDefinition = "bigint default -1")
    protected Long dataVersion = -1L;

    @Transient
    protected int toBeDel = 0;

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getLastModifyUser() {
        return lastModifyUser;
    }

    public void setLastModifyUser(String lastModifyUser) {
        this.lastModifyUser = lastModifyUser;
    }

    public Date getLastModifyTime() {
        return lastModifyTime;
    }

    public void setLastModifyTime(Date lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public Long getDataVersion() {
        return dataVersion;
    }

    public void setDataVersion(Long dataVersion) {
        this.dataVersion = dataVersion;
    }

    public void updateLMI() {
        lastModifyTime = new Date();
    }

    public void updateLMI(String lmu) {
        updateLMI();
        if (!Strings.isNullOrEmpty(lmu)) {
            lastModifyUser = lmu;
        }
    }

    @Override
    @Transient
    public int getToBeDel() {
        return toBeDel;
    }

    @Override
    public void setToBeDel(int toBeDel) {
        this.toBeDel = toBeDel;
    }

    @Override
    public String valueKey() {
        return "-";
    }

    @Override
    public boolean valueEquals(Object o) {
        return false;
    }
}
