package com.valor.mfc.vms.common.tools.http;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/**
 * Created by Frank.Huang on 2016/7/19.
 */
public class HttpParameterTools {
    private static final Logger logger = LoggerFactory.getLogger(HttpParameterTools.class);


    public static Map<String,String> getCookies(HttpServletRequest request) {
        Map<String,String> cookieMap = Maps.newHashMap();
        Cookie[] cookies = request.getCookies();
        if (cookies != null){
            for (Cookie cookie:cookies){
                cookieMap.put(cookie.getName(),cookie.getValue());
            }
        }

        return cookieMap;
    }

    public static String getCookie(HttpServletRequest request,String cookieKey) {
        Map<String,String> cookieMap = Maps.newHashMap();
        Cookie[] cookies = request.getCookies();
        if (cookies != null){
            for (Cookie cookie: cookies){
                if (cookie.getName().compareTo(cookieKey)==0){
                    return cookie.getValue();
                }
            }
        }

        return "";
    }

    public static Long getLongParameter(HttpServletRequest request,String key){
        String value = getCookie(request,key);
        if (Strings.isNullOrEmpty(value)){
            value = HttpTools.getHttpParameter(request,key);
        }

        if (Strings.isNullOrEmpty(value)){
            return null;
        }

        return Long.valueOf(value);
    }

    public static String getParameter(HttpServletRequest request,String key){
        String value = getCookie(request,key);
        if (Strings.isNullOrEmpty(value)){
            value = HttpTools.getHttpParameter(request, key);
//            if (Strings.isNullOrEmpty(value)){
//                logger.info("{}={}",key,value);
//            }
        }

        return value;
    }

}
