package com.valor.mfc.vms.common.web.request;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * Project     : yamj3
 * Description :
 * Author      : Frank
 * Create Time : 23:45
 */
public class PagingArgs extends BaseRequestArgs implements IPagingArgs {
    private static int MAX_PAGE_SIZE = 300;
    private int pageId   =1;  //默认取第一个分页
    private int pageSize =10; //默认每个分页10个元素
    private String sort="";    //排序参数,格式为:{key:value{ans|desc};}
    private String filter="";  //过滤参数,格式为:{key:value;key:value1,value2:in;}

    @Override
    public int getPageId() {
        return pageId
        ;
    }

    @Override
    public void setPageId(int pageId) {
        if (pageId <=1){
            this.pageId = 1;
        }else {
            this.pageId = pageId;
        }
    }

    @Override
    public int getPageSize() {
        return pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        if (pageSize > MAX_PAGE_SIZE){
            argsValid = false;
            setVerifyMsg("PageSize","Page size large than MAX("+MAX_PAGE_SIZE+").");
        }else if(pageSize > 0){
            this.pageSize = pageSize;
        }else{
            this.pageSize = 10;
        }
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    @Override
    @JsonIgnore
    public int getPageStart() {
        return ((pageId-1) * pageSize);
    }


    public String getFilter() {
        return filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

}
