package com.valor.mfc.vms.common.web.tools;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;

import com.valor.mfc.vms.api.model.common.EResultItem;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.EnumSet;
import java.util.List;

/**
 * Created by Frank.Huang on 2016/7/7.
 */
public class ResultItemTools {
    private static final Logger logger = LoggerFactory.getLogger(ResultItemTools.class);

    public static EnumSet<EResultItem> parseResult(String results) {
        EnumSet<EResultItem> appendResults = EnumSet.noneOf(EResultItem.class);
        if (Strings.isNullOrEmpty(results)){
            return appendResults;
        }

        try {
            List<String> appends = Splitter.on(",").trimResults().splitToList(results);
            appends.forEach(e->{
                try {
                    EResultItem append = EResultItem.valueOf(e);
                    appendResults.add(append);
                }catch (Exception ex){
                    logger.error("Invalid Result Item:[{}]",e);
                }
            });
        }catch (Exception e){
            logger.error("Invalid Result Item:[{}]",results);
        }

        return appendResults;
    }

}
