/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.common.cache.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisCommands;

@Component
public class MFCRedisUtil {
    private static final Logger logger = LoggerFactory.getLogger(MFCRedisUtil.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public MFCRedisUtil(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("redis operation-[expire] exception", (Throwable)e);
            return false;
        }
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            logger.error("redis operation-[hasKey] exception", (Throwable)e);
            return false;
        }
    }

    public void del(String ... key) {
        try {
            if (key != null && key.length > 0) {
                if (key.length == 1) {
                    this.redisTemplate.delete((Object)key[0]);
                } else {
                    this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
                }
            }
        }
        catch (Exception e) {
            logger.error("redis operation del exception", (Throwable)e);
        }
    }

    public Object get(String key) {
        try {
            if (key != null) {
                return this.redisTemplate.opsForValue().get((Object)key);
            }
        }
        catch (Exception e) {
            logger.error("redis operation-[get] exception[{}]", (Throwable)e);
        }
        return null;
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            logger.error("redis operation-[set]", (Throwable)e);
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("redis operation-[set]", (Throwable)e);
            return false;
        }
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            logger.error("redis operation-[hmset] exception", (Throwable)e);
            return false;
        }
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("redis operation-[hmset] exception", (Throwable)e);
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            logger.error("redis operation-[hset] exception", (Throwable)e);
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("redis operation-[hset] exception", (Throwable)e);
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            logger.error("redis operation-[sGet] exception", (Throwable)e);
            return null;
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            logger.error("redis operation-[sHasKey] exception", (Throwable)e);
            return false;
        }
    }

    public long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            logger.error("sSet-exception", (Throwable)e);
            return 0L;
        }
    }

    public long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            logger.error("sSetAndTime-exception", (Throwable)e);
            return 0L;
        }
    }

    public long sGetSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            logger.error("sGetSetSize-exception", (Throwable)e);
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            logger.error("setRemove-exception", (Throwable)e);
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            logger.error("lGet-exception", (Throwable)e);
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            logger.error("lGetListSize-exception", (Throwable)e);
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            logger.error("lGetIndex-exception", (Throwable)e);
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            logger.error("lSet-exception", (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("lSet-exception", (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            logger.error("lSet-exception", (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("lSet-exception", (Throwable)e);
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            logger.error("lUpdateIndex-exception", (Throwable)e);
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            Long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (Exception e) {
            logger.error("lRemove exception", (Throwable)e);
            return 0L;
        }
    }

    public boolean zAdd(String key, Object member, double score, long time) {
        try {
            this.redisTemplate.opsForZSet().add((Object)key, member, score);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("redis error: ", (Throwable)e);
            return false;
        }
    }

    public boolean zAdds(String key, Set<ZSetOperations.TypedTuple<Object>> tuples, long time) {
        try {
            this.redisTemplate.opsForZSet().add((Object)key, tuples);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("redis error: ", (Throwable)e);
            return false;
        }
    }

    public boolean zAddWithinCount(String key, Object member, double score, long time, long count) {
        try {
            Long redisTotalCount;
            this.redisTemplate.opsForZSet().add((Object)key, member, score);
            if (time > 0L) {
                this.expire(key, time);
            }
            if ((redisTotalCount = this.redisTemplate.opsForZSet().zCard((Object)key)) > count) {
                this.redisTemplate.opsForZSet().removeRange((Object)key, count, -1L);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("redis error: ", (Throwable)e);
            return false;
        }
    }

    public Set<Object> zRangeByScore(String key, double minScore, double maxScore) {
        try {
            return this.redisTemplate.opsForZSet().rangeByScore((Object)key, minScore, maxScore);
        }
        catch (Exception e) {
            logger.error("redis error: ", (Throwable)e);
            return null;
        }
    }

    public Set<Object> zReverseRangeByscore(String key, double minScore, double maxScore) {
        try {
            return this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, minScore, maxScore);
        }
        catch (Exception e) {
            logger.error("redis error: ", (Throwable)e);
            return null;
        }
    }

    public Set<Object> zReverseRangeByscore(String key, double minScore, double maxScore, long offset, long count) {
        try {
            return this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, minScore, maxScore, offset, count);
        }
        catch (Exception e) {
            logger.error("redis error: ", (Throwable)e);
            return null;
        }
    }

    public Double zScore(String key, Object member) {
        try {
            return this.redisTemplate.opsForZSet().score((Object)key, member);
        }
        catch (Exception e) {
            logger.error("redis error: ", (Throwable)e);
            return null;
        }
    }

    public Long zRank(String key, Object member) {
        try {
            return this.redisTemplate.opsForZSet().rank((Object)key, member);
        }
        catch (Exception e) {
            logger.error("redis error: ", (Throwable)e);
            return null;
        }
    }

    public Long zCard(String key) {
        try {
            return this.redisTemplate.opsForZSet().zCard((Object)key);
        }
        catch (Exception e) {
            logger.error("redis error: ", (Throwable)e);
            return null;
        }
    }

    public Cursor<ZSetOperations.TypedTuple<Object>> zscan(String key) {
        try {
            Cursor cursor = this.redisTemplate.opsForZSet().scan((Object)key, ScanOptions.NONE);
            return cursor;
        }
        catch (Exception e) {
            logger.error("redis error: ", (Throwable)e);
            return null;
        }
    }

    public boolean zRem(String key, Object ... values) {
        try {
            this.redisTemplate.opsForZSet().remove((Object)key, values);
            return true;
        }
        catch (Exception e) {
            logger.error("redis error: ", (Throwable)e);
            return false;
        }
    }

    public boolean zRemrangebyscore(String key, double min, double max) {
        try {
            this.redisTemplate.opsForZSet().removeRangeByScore((Object)key, min, max);
            return true;
        }
        catch (Exception e) {
            logger.error("redis error: ", (Throwable)e);
            return false;
        }
    }

    public boolean zRemoveRange(String key, long start, long end) {
        try {
            this.redisTemplate.opsForZSet().removeRange((Object)key, start, end);
            return true;
        }
        catch (Exception e) {
            logger.error("redis error: ", (Throwable)e);
            return false;
        }
    }

    public void delete(Collection<String> keys) {
        try {
            this.redisTemplate.delete(keys);
        }
        catch (Exception e) {
            logger.error("delete keys[" + keys + "] exception", (Throwable)e);
        }
    }

    public Set<String> keys(String pattern) {
        Set keysSet = null;
        try {
            keysSet = this.redisTemplate.keys((Object)pattern);
        }
        catch (Exception e) {
            logger.error("keys[" + pattern + "] exception", (Throwable)e);
        }
        return keysSet;
    }

    public boolean setnx(String key, String value, Long expiredMilliseconds) {
        try {
            RedisCallback callback = connection -> {
                JedisCommands commands = (JedisCommands)connection.getNativeConnection();
                return commands.set(key, value, "NX", "PX", expiredMilliseconds.longValue());
            };
            String result = (String)this.redisTemplate.execute(callback);
            return !StringUtils.isEmpty((CharSequence)result);
        }
        catch (Exception e) {
            try {
                this.redisTemplate.delete((Object)key);
            }
            catch (Exception ex) {
                logger.error("[REDIS]delete key {}, exception {}", (Object)key, (Object)ex);
            }
            logger.error("[REDIS]Try get lock error.KEY[{}]-VALUE[{}]-EXPIRE[{}]", new Object[]{key, value, expiredMilliseconds, e});
            return true;
        }
    }

    public boolean getLocker(String lockerName, long expiredMilliseconds) {
        return this.setnx(lockerName, "true", expiredMilliseconds);
    }

    public <V> Map<String, V> mGet(Set<String> keySet) {
        try {
            ArrayList<String> keys = new ArrayList<String>(keySet);
            List objs = this.redisTemplate.opsForValue().multiGet(keys);
            HashMap resultMap = new HashMap();
            for (int i = 0; i < keys.size(); ++i) {
                Object v = objs.get(i);
                resultMap.put(keys.get(i), v);
            }
            return resultMap;
        }
        catch (Exception ex) {
            logger.error("mGet(),exception ", (Throwable)ex);
            return null;
        }
    }

    public <V> Map<String, V> mGetWithoutNull(Set<String> keySet) {
        try {
            ArrayList<String> keys = new ArrayList<String>(keySet);
            List objs = this.redisTemplate.opsForValue().multiGet(keys);
            HashMap resultMap = new HashMap();
            for (int i = 0; i < keys.size(); ++i) {
                Object v = objs.get(i);
                if (v == null) continue;
                resultMap.put(keys.get(i), v);
            }
            return resultMap;
        }
        catch (Exception ex) {
            logger.error("mGet(),exception ", (Throwable)ex);
            return null;
        }
    }

    public <V> void pipSetEx(final Map<String, V> map, final long seconds) {
        try {
            List list = this.redisTemplate.executePipelined((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection redisConnection) throws DataAccessException {
                    for (Map.Entry e : map.entrySet()) {
                        String key = (String)e.getKey();
                        Object value = e.getValue();
                        RedisSerializer serializer = MFCRedisUtil.this.redisTemplate.getValueSerializer();
                        byte[] valBytes = serializer.serialize(value);
                        if (seconds > 0L) {
                            redisConnection.setEx(key.getBytes(), seconds, valBytes);
                            continue;
                        }
                        redisConnection.set(key.getBytes(), valBytes);
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            logger.error("pipSetEx(),exception:", (Throwable)ex);
        }
    }
}

